/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.inchange;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import cz.solnet.inchange.UserAndGroups;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class MemCache {
    static MemCachedClient mc;
    static String fake_user;
    static String fake_groups;
    static Map<String, String> fake_props;
    static Logger log;

    static String getItem(String s, String attrName) {
        if (s.startsWith(attrName + "=")) {
            return s.substring(attrName.length() + 1);
        }
        return null;
    }

    public static UserAndGroups getPolicy(String key) {
        String val;
        String user = "-NOBODY-";
        ArrayList<String> groups = new ArrayList<String>();
        if (fake_user != null) {
            user = fake_user;
        }
        if (fake_groups != null) {
            for (String g : fake_groups.split(",")) {
                groups.add(g);
            }
        }
        String string = val = key == null ? null : (String)mc.get(key);
        if (val != null) {
            String[] vals;
            for (String s : vals = val.split("\r\n")) {
                String x = MemCache.getItem(s, "UserName");
                if (x != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getPolicy(login_id=" + key + ") UserName: " + x + "\n"));
                    }
                    if (fake_user != null) continue;
                    user = x;
                    continue;
                }
                x = MemCache.getItem(s, "Groups");
                if (x != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getPolicy(login_id=" + key + ") Groups: " + x + "\n"));
                    }
                    if (fake_groups != null) continue;
                    for (String g : x.split(":")) {
                        if (g.isEmpty()) continue;
                        groups.add(g);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("getPolicy(login_id=" + key + ") unparsed line: " + s + "\n"));
            }
        }
        return new UserAndGroups(user, groups, key);
    }

    public static UserAndGroups getPolicy(HttpServletRequest request, Map<String, String> h) {
        return MemCache.getPolicyN(request, h, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAndGroups getPolicyN(HttpServletRequest request, Map<String, String> h, int maxReconnect) {
        String cs = null;
        String remote_user = null;
        Principal principal = null;
        if (request != null) {
            remote_user = request.getRemoteUser();
            principal = request.getUserPrincipal();
            if (remote_user != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remote_user=" + remote_user));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"remote_user=NULL");
            }
            if (request.getCookies() != null) {
                for (Cookie c : request.getCookies()) {
                    if (!c.getName().equals("login_id")) continue;
                    cs = c.getValue();
                }
            }
        } else {
            log.error((Object)"no-request");
        }
        UserAndGroups ug = null;
        if (cs != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cookie login_id=" + cs));
            }
            ug = MemCache.getPolicy(cs);
        } else {
            log.info((Object)"no-cookie login_id");
        }
        if (remote_user != null && (ug == null || "-NOBODY-".equals(ug.getUser()))) {
            ArrayList<String> groups;
            block52: {
                groups = new ArrayList<String>();
                DirContext context = null;
                InitialContext ctx = null;
                String ctxName = "ldap/inchange";
                try {
                    SearchResult result;
                    ctx = new InitialContext();
                    try {
                        context = (DirContext)ctx.lookup(ctxName);
                    }
                    catch (NamingException e) {
                        context = (DirContext)ctx.lookup("java:comp/env/" + ctxName);
                    }
                    SearchControls ctrl = new SearchControls();
                    ctrl.setSearchScope(2);
                    ctrl.setReturningAttributes(new String[0]);
                    String dn = null;
                    NamingEnumeration<SearchResult> enumeration = null;
                    try {
                        enumeration = context.search("", "(&(uid=" + remote_user + ")(objectClass=posixAccount)(!(objectClass=sambaSamAccount)))", ctrl);
                        while (enumeration.hasMore()) {
                            result = enumeration.next();
                            dn = result.getNameInNamespace();
                        }
                    }
                    finally {
                        if (enumeration != null) {
                            try {
                                enumeration.close();
                            }
                            catch (NamingException e) {
                                log.error((Object)"Error closing LDAP results", (Throwable)e);
                            }
                        }
                    }
                    if (dn == null) break block52;
                    ctrl.setReturningAttributes(new String[]{"cn"});
                    enumeration = null;
                    try {
                        enumeration = context.search("", "(&(uniqueMember=" + dn + ")(objectClass=posixGroup))", ctrl);
                        while (enumeration.hasMore()) {
                            result = enumeration.next();
                            Attributes attribs = result.getAttributes();
                            NamingEnumeration<?> values = ((BasicAttribute)attribs.get("cn")).getAll();
                            while (values.hasMore()) {
                                groups.add(values.next().toString());
                            }
                        }
                    }
                    finally {
                        if (enumeration != null) {
                            try {
                                enumeration.close();
                            }
                            catch (NamingException e) {
                                log.error((Object)"Error closing LDAP results", (Throwable)e);
                            }
                        }
                    }
                }
                catch (NoInitialContextException e) {
                    log.error((Object)("no-ldap-ds - " + e.getClass().getName() + ":" + e.getLocalizedMessage()), (Throwable)e);
                }
                catch (CommunicationException e) {
                    log.warn((Object)("reconnecting to ldap: maxReconnect=" + maxReconnect));
                    try {
                        InitialDirContext c2 = new InitialDirContext(context.getEnvironment());
                        context.close();
                        try {
                            ctx.createSubcontext("ldap");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ctx.rebind(ctxName, (Object)c2);
                    }
                    catch (Exception e1) {
                        log.error((Object)("reconnecting to ldap: " + e1.getClass().getName() + ":" + e1.getLocalizedMessage()));
                    }
                    if (maxReconnect <= 0) break block52;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return MemCache.getPolicyN(request, h, maxReconnect - 1);
                }
                catch (NamingException e) {
                    log.error((Object)("no-ldap-ds " + ctxName + " - " + e.getClass().getName() + ":" + e.getExplanation()), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)("no-ldap-ds - " + e.getClass().getName() + ":" + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            ug = new UserAndGroups(remote_user, groups, null);
        }
        if (ug == null) {
            ug = MemCache.getPolicy(null);
        }
        if (h != null) {
            ug.readPropsFromHash(h);
        }
        if (fake_props != null) {
            ug.readPropsFromHash(fake_props);
        }
        try {
            ug.readPropsFromDB("webis2");
        }
        catch (NoInitialContextException e) {
            log.warn((Object)("cannot read props from DB: " + e.getLocalizedMessage()));
        }
        catch (NameNotFoundException e) {
            log.warn((Object)("cannot read props from DB: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            log.error((Object)"cannot read props from DB", (Throwable)e);
        }
        log.info((Object)("user=" + ug.getUser() + ", groups=" + ug.getGroupsString()));
        return ug;
    }

    static {
        fake_user = null;
        fake_groups = null;
        fake_props = null;
        log = Logger.getLogger(MemCache.class);
        String[] serverlist = new String[]{"localhost:11211"};
        try {
            String cp = MemCache.class.getProtectionDomain().getCodeSource().getLocation().toString().replace("inchange.jar", "");
            String prop_file = cp + "memcacheclient.properties";
            URL url = new URL(prop_file);
            if (url == null) {
                log.info((Object)("cannot get prop file: " + prop_file));
            } else {
                log.info((Object)("loading fakes from prop file: " + prop_file));
                Properties p = new Properties();
                p.load(new FileInputStream(new File(url.getFile())));
                fake_user = p.getProperty("memcacheclient.user");
                fake_groups = p.getProperty("memcacheclient.groups");
                fake_props = new LinkedHashMap<String, String>();
                String prefix = "memcacheclient.properties.";
                for (String pName : p.stringPropertyNames()) {
                    if (!pName.startsWith(prefix)) continue;
                    log.debug((Object)("fake_props:" + pName.replaceFirst("^" + prefix, "") + "=" + p.getProperty(pName)));
                    fake_props.put(pName.replaceFirst("^" + prefix, ""), p.getProperty(pName));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("error: " + e.toString()));
        }
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(serverlist);
        pool.initialize();
        mc = new MemCachedClient();
        mc.setTransCoder((TransCoder)new MyTransCoder());
    }

    static class MyTransCoder
    implements TransCoder {
        MyTransCoder() {
        }

        public Object decode(InputStream i) throws IOException {
            byte[] bytes = new byte[4001];
            if (i.read(bytes, 0, 1000) > 0) {
                return new String(bytes, "utf8");
            }
            return new String("");
        }

        public int encode(SockOutputStream o, Object obj) throws IOException {
            byte[] bytes = ((String)obj).getBytes("utf8");
            o.write(bytes);
            return bytes.length;
        }
    }
}

