/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.inchange;

import cz.solnet.inchange.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserAndGroups {
    static Logger log = Logger.getLogger(UserAndGroups.class);
    private String user;
    private List<String> groups;
    private String cookiestring = null;
    private Map<String, Map<String, String>> props = new LinkedHashMap<String, Map<String, String>>();

    public String getUser() {
        if (this.user == null) {
            return "-NOBODY-";
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getLogin() {
        return this.getUser().split("@")[0].toUpperCase();
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String getGroupsString() {
        String gtxt = "*";
        for (String g : this.getGroups()) {
            gtxt = gtxt + ',';
            gtxt = gtxt + g;
        }
        return gtxt;
    }

    public String getCookiestring() {
        return this.cookiestring;
    }

    public void setCookiestring(String cookiestring) {
        this.cookiestring = cookiestring;
    }

    UserAndGroups(String user, List<String> groups, String cookiestring) {
        this.user = user;
        this.groups = groups;
        this.cookiestring = cookiestring;
    }

    public Set<String> getPropTypes() {
        return this.props.keySet();
    }

    public Map<String, String> getProps(String propType) {
        if (propType != null && this.props.containsKey(propType)) {
            return this.props.get(propType);
        }
        return new LinkedHashMap<String, String>();
    }

    public boolean isPropEnabled(String propType, String newValue) {
        if (propType == null || newValue == null) {
            return false;
        }
        Map<String, String> h = this.props.get(propType);
        if (h == null) {
            return false;
        }
        return h.containsKey(newValue);
    }

    public void addPropValue(String propType, String newValue, String description) {
        if (propType == null || newValue == null) {
            return;
        }
        Map<String, String> h = this.props.get(propType);
        if (h == null) {
            h = new LinkedHashMap<String, String>();
            this.props.put(propType, h);
        }
        h.put(newValue, description);
    }

    public void readPropsFromDB(String dsName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reading properties from DB for the user='" + this.getUser() + "', groups='" + this.getGroupsString() + "'"));
        }
        Connection con = ConnectionManager.getConnection(dsName);
        PreparedStatement pstmt = con.prepareStatement("select * from reporting.get_properties_list(?,?)");
        pstmt.setString(1, this.getUser());
        pstmt.setString(2, this.getGroupsString());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            this.addPropValue(rs.getString("property_type"), rs.getString("property_name"), rs.getString("property_description"));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DB -> propType=" + rs.getString("property_type") + ",propName=" + rs.getString("property_name") + ",propValue=" + rs.getString("property_description")));
        }
        rs.close();
        pstmt.close();
        con.close();
    }

    public void readPropsFromHash(Map<String, String> h) {
        for (Map.Entry<String, String> e : h.entrySet()) {
            String propType = e.getKey();
            for (String s : e.getValue().split(";")) {
                String[] av = s.split(":");
                if (av.length < 2) continue;
                String[] users = "*".split(",");
                if (av.length > 2) {
                    users = av[2].split(",");
                }
                boolean validUser = false;
                for (String u : users) {
                    if (!this.getUser().equals(u) && !u.equals("*")) continue;
                    validUser = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HA -> propType=" + propType + ",propName=" + av[1] + ",propValue=" + av[0] + ",validUser=" + validUser));
                }
                if (!validUser) continue;
                this.addPropValue(propType, av[1], av[0]);
            }
        }
    }
}

