/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.SchoonerSockIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;

public final class SockInputStream
extends InputStream {
    private SchoonerSockIO sock;
    private int limit;
    private int count = 0;

    public final int getWillRead() {
        return this.limit;
    }

    public final void willRead(int n) {
        this.limit = n;
        this.count = 0;
    }

    public SockInputStream(SchoonerSockIO schoonerSockIO, int n) throws IOException {
        this.sock = schoonerSockIO;
        this.willRead(n);
        schoonerSockIO.readBuf.clear();
        schoonerSockIO.getChannel().read(schoonerSockIO.readBuf);
        schoonerSockIO.readBuf.flip();
    }

    public SockInputStream(SchoonerSockIO schoonerSockIO) throws IOException {
        this(schoonerSockIO, schoonerSockIO.readBuf.remaining());
    }

    public final int read() throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        byte by = 0;
        try {
            by = this.sock.readBuf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.readFromChannel();
            by = this.sock.readBuf.get();
        }
        ++this.count;
        return by & 0xFF;
    }

    private final void readFromChannel() throws IOException {
        this.sock.readBuf.clear();
        this.sock.getChannel().read(this.sock.readBuf);
        this.sock.readBuf.flip();
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.limit - this.count;
        int n6 = n2 = n2 < n5 ? n2 : n5;
        while (n2 - n3 > 0) {
            n4 = this.sock.readBuf.remaining();
            n4 = n4 < n2 - n3 ? n4 : n2 - n3;
            this.sock.readBuf.get(byArray, n + n3, n4);
            if (n4 != n2 - n3) {
                this.readFromChannel();
            }
            n3 += n4;
        }
        this.count += n2;
        return n2;
    }

    public final byte[] getBuffer() throws IOException {
        byte[] byArray = new byte[this.limit - this.count];
        this.read(byArray);
        return byArray;
    }

    public final String getLine() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.read()) != -1) {
            byteArrayOutputStream.write(n);
            if (n != 10) continue;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public int available() throws IOException {
        return this.sock.readBuf.remaining();
    }
}

