/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.danga.MemCached.Logger;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.Command;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class StorageCommand
extends Command {
    public static Logger log = Logger.getLogger(StorageCommand.class.getName(), 4);
    public static final byte[] STORED = "STORED\r\n".getBytes();
    public static final byte[] NOT_STORED = "NOT_STORED\r\n".getBytes();
    public final byte[] BLAND_DATA_SIZE = "       ".getBytes();
    public static final byte[] B_RETURN = "\r\n".getBytes();
    private int flags;
    private TransCoder transCoder = new ObjectTransCoder();
    private Object value;
    private int valLen = 0;
    private int offset;
    private Long casUnique;

    public StorageCommand(String string, String string2, Object object, Date date, Integer n, Long l) {
        this.init(string, string2, object, date, n, l);
    }

    public StorageCommand(String string, String string2, Object object, Date date, Integer n, Long l, TransCoder transCoder) {
        this.init(string, string2, object, date, n, l);
        this.transCoder = transCoder;
    }

    private void init(String string, String string2, Object object, Date date, Integer n, Long l) {
        this.flags = NativeHandler.getMarkerFlag(object);
        String string3 = new StringBuffer().append(string).append(" ").append(string2).append(" ").append(this.flags).append(" ").append(date.getTime() / 1000L).append(" ").toString();
        this.textLine = string3.getBytes();
        this.value = object;
        this.casUnique = l;
    }

    private boolean writeDataBlock(SchoonerSockIO schoonerSockIO) throws IOException {
        byte[] byArray;
        SockOutputStream sockOutputStream = new SockOutputStream(schoonerSockIO);
        if (this.flags != 0) {
            byArray = NativeHandler.encode(this.value);
            sockOutputStream.write(byArray);
            this.valLen = byArray.length;
        } else {
            this.valLen = this.transCoder.encode(sockOutputStream, this.value);
        }
        schoonerSockIO.writeBuf.put(B_RETURN);
        byArray = new Integer(this.valLen).toString().getBytes();
        int n = schoonerSockIO.writeBuf.position();
        schoonerSockIO.writeBuf.position(this.offset);
        schoonerSockIO.writeBuf.put(byArray);
        schoonerSockIO.writeBuf.position(n);
        return true;
    }

    public short request(SchoonerSockIO schoonerSockIO) throws IOException {
        short s = schoonerSockIO.preWrite();
        schoonerSockIO.writeBuf.put(this.textLine);
        this.offset = schoonerSockIO.writeBuf.position();
        schoonerSockIO.writeBuf.put(this.BLAND_DATA_SIZE);
        if (this.casUnique != 0L) {
            schoonerSockIO.writeBuf.put((" " + this.casUnique.toString()).getBytes());
        }
        schoonerSockIO.writeBuf.put(B_RETURN);
        if (this.value != null) {
            this.writeDataBlock(schoonerSockIO);
        }
        schoonerSockIO.writeBuf.flip();
        schoonerSockIO.getByteChannel().write(schoonerSockIO.writeBuf);
        return s;
    }

    public boolean response(SchoonerSockIO schoonerSockIO, short s) throws IOException {
        byte[] byArray = schoonerSockIO.getResponse(s);
        return Arrays.equals(STORED, byArray);
    }
}

