/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private String name;
    private int level;

    public void setLevel(int n) {
        this.level = n;
    }

    public final int getLevel() {
        return this.level;
    }

    protected Logger(String string, int n) {
        this.name = string;
        this.level = n;
    }

    protected Logger(String string) {
        this(string, 1);
    }

    public static synchronized Logger getLogger(String string, int n) {
        Logger logger = Logger.getLogger(string);
        if (logger.getLevel() != n) {
            logger.setLevel(n);
        }
        return logger;
    }

    public static synchronized Logger getLogger(String string) {
        Logger logger = null;
        if (loggers.containsKey(string)) {
            logger = loggers.get(string);
        } else {
            logger = new Logger(string);
            loggers.put(string, logger);
        }
        return logger;
    }

    private void log(String string, Throwable throwable) {
        System.out.println(this.name + " " + new Date() + " - " + string);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.level > 0) {
            return;
        }
        this.log(string, throwable);
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public final boolean isDebugEnabled() {
        return this.level <= 0;
    }

    public void info(String string, Throwable throwable) {
        if (this.level > 1) {
            return;
        }
        this.log(string, throwable);
    }

    public void info(String string) {
        this.info(string, null);
    }

    public final boolean isInfoEnabled() {
        return this.level <= 1;
    }

    public void warn(String string, Throwable throwable) {
        if (this.level > 2) {
            return;
        }
        this.log(string, throwable);
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public void error(String string, Throwable throwable) {
        if (this.level > 3) {
            return;
        }
        this.log(string, throwable);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void fatal(String string, Throwable throwable) {
        if (this.level > 4) {
            return;
        }
        this.log(string, throwable);
    }

    public void fatal(String string) {
        this.fatal(string, null);
    }
}

