/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.ErrorHandler;
import com.danga.MemCached.Logger;
import com.schooner.MemCached.AscIIClient;
import com.schooner.MemCached.AscIIUDPClient;
import com.schooner.MemCached.BinaryClient;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.TransCoder;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemCachedClient {
    MemCachedClient client;
    protected ClassLoader classLoader;
    protected ErrorHandler errorHandler;
    public static Logger log = Logger.getLogger(MemCachedClient.class.getName(), 4);
    public static final String VALUE = "VALUE";
    public static final String STATS = "STAT";
    public static final String ITEM = "ITEM";
    public static final String DELETED = "DELETED\r\n";
    public static final String SYNCED = "SYNCED\r\n";
    public static final String NOTFOUND = "NOT_FOUND\r\n";
    public static final String STORED = "STORED\r\n";
    public static final String OK = "OK\r\n";
    public static final String END = "END\r\n";
    public static final String ERROR = "ERROR\r\n";
    public static final String CLIENT_ERROR = "CLIENT_ERROR\r\n";
    public static final int COMPRESS_THRESH = 30720;
    public static final String SERVER_ERROR = "SERVER_ERROR\r\n";
    public static final byte[] B_RETURN = "\r\n".getBytes();
    public static final byte[] B_END = "END\r\n".getBytes();
    public static final byte[] B_NOTFOUND = "NOT_FOUND\r\n".getBytes();
    public static final byte[] B_DELETED = "DELETED\r\r".getBytes();
    public static final byte[] B_STORED = "STORED\r\r".getBytes();
    public static final byte MAGIC_REQ = -128;
    public static final byte MAGIC_RESP = -127;
    public static final int F_COMPRESSED = 2;
    public static final int F_SERIALIZED = 8;
    public static final int STAT_NO_ERROR = 0;
    public static final int STAT_KEY_NOT_FOUND = 1;
    public static final int STAT_KEY_EXISTS = 2;
    public static final int STAT_VALUE_TOO_BIG = 3;
    public static final int STAT_INVALID_ARGUMENTS = 4;
    public static final int STAT_ITEM_NOT_STORED = 5;
    public static final int STAT_UNKNOWN_COMMAND = 129;
    public static final int STAT_OUT_OF_MEMORY = 130;
    public static final byte OPCODE_GET = 0;
    public static final byte OPCODE_SET = 1;
    public static final byte OPCODE_ADD = 2;
    public static final byte OPCODE_REPLACE = 3;
    public static final byte OPCODE_DELETE = 4;
    public static final byte OPCODE_INCREMENT = 5;
    public static final byte OPCODE_DECREMENT = 6;
    public static final byte OPCODE_QUIT = 7;
    public static final byte OPCODE_FLUSH = 8;
    public static final byte OPCODE_GETQ = 9;
    public static final byte OPCODE_NOOP = 10;
    public static final byte OPCODE_VERSION = 11;
    public static final byte OPCODE_GETK = 12;
    public static final byte OPCODE_GETKQ = 13;
    public static final byte OPCODE_APPEND = 14;
    public static final byte OPCODE_PREPEND = 15;
    public static final byte OPCODE_STAT = 16;
    public final byte[] BLAND_DATA_SIZE = "       ".getBytes();
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 8192;
    public static final int MARKER_INTEGER = 4;
    public static final int MARKER_LONG = 16384;
    public static final int MARKER_CHARACTER = 16;
    public static final int MARKER_STRING = 32;
    public static final int MARKER_STRINGBUFFER = 64;
    public static final int MARKER_FLOAT = 128;
    public static final int MARKER_SHORT = 256;
    public static final int MARKER_DOUBLE = 512;
    public static final int MARKER_DATE = 1024;
    public static final int MARKER_STRINGBUILDER = 2048;
    public static final int MARKER_BYTEARR = 4096;
    public static final int MARKER_OTHERS = 0;

    public boolean isUseBinaryProtocol() {
        return this.client.isUseBinaryProtocol();
    }

    protected MemCachedClient(String string, String string2) {
        this.client = null;
    }

    public MemCachedClient() {
        this(null, true, false);
    }

    public MemCachedClient(boolean bl) {
        this(null, true, bl);
    }

    public MemCachedClient(String string) {
        this(string, true, false);
    }

    public MemCachedClient(String string, boolean bl) {
        this(string, true, bl);
    }

    public MemCachedClient(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public MemCachedClient(String string, boolean bl, boolean bl2) {
        this.client = bl2 ? new BinaryClient(string) : (bl ? new AscIIClient(string) : new AscIIUDPClient(string));
    }

    public MemCachedClient(String string, boolean bl, boolean bl2, ClassLoader classLoader, ErrorHandler errorHandler) {
        this.client = bl2 ? new BinaryClient(string, classLoader, errorHandler) : (bl ? new AscIIClient(string, classLoader, errorHandler) : new AscIIUDPClient(string, classLoader, errorHandler));
    }

    public MemCachedClient(ClassLoader classLoader) {
        this();
        this.client.setClassLoader(classLoader);
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler) {
        this(null, true, false, classLoader, errorHandler);
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler, String string) {
        this(string, true, false, classLoader, errorHandler);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.client.setClassLoader(classLoader);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.client.setErrorHandler(errorHandler);
    }

    public void setCompressEnable(boolean bl) {
        this.client.setCompressEnable(bl);
    }

    public void setCompressThreshold(long l) {
        this.client.setCompressThreshold(l);
    }

    public void setDefaultEncoding(String string) {
        this.client.setDefaultEncoding(string);
    }

    public void setPrimitiveAsString(boolean bl) {
        this.client.setPrimitiveAsString(bl);
    }

    public void setSanitizeKeys(boolean bl) {
        this.client.setSanitizeKeys(bl);
    }

    public boolean keyExists(String string) {
        return this.client.keyExists(string);
    }

    public boolean delete(String string) {
        return this.client.delete(string);
    }

    public boolean delete(String string, Date date) {
        return this.client.delete(string, date);
    }

    public boolean delete(String string, Integer n, Date date) {
        return this.client.delete(string, n, date);
    }

    public boolean set(String string, Object object) {
        return this.client.set(string, object);
    }

    public boolean set(String string, Object object, Integer n) {
        return this.client.set(string, object, n);
    }

    public boolean set(String string, Object object, Date date) {
        return this.client.set(string, object, date);
    }

    public boolean set(String string, Object object, Date date, Integer n) {
        return this.client.set(string, object, date, n);
    }

    public boolean add(String string, Object object) {
        return this.client.add(string, object);
    }

    public boolean add(String string, Object object, Integer n) {
        return this.client.add(string, object, n);
    }

    public boolean add(String string, Object object, Date date) {
        return this.client.add(string, object, date);
    }

    public boolean add(String string, Object object, Date date, Integer n) {
        return this.client.add(string, object, date, n);
    }

    public boolean replace(String string, Object object) {
        return this.client.replace(string, object);
    }

    public boolean replace(String string, Object object, Integer n) {
        return this.client.replace(string, object, n);
    }

    public boolean replace(String string, Object object, Date date) {
        return this.client.replace(string, object, date);
    }

    public boolean replace(String string, Object object, Date date, Integer n) {
        return this.client.replace(string, object, date, n);
    }

    public boolean storeCounter(String string, long l) {
        return this.storeCounter(string, new Long(l));
    }

    public boolean storeCounter(String string, Long l) {
        return this.storeCounter(string, l, null);
    }

    public boolean storeCounter(String string, Long l, Integer n) {
        return this.set(string, (Object)l, n);
    }

    public long getCounter(String string) {
        return this.getCounter(string, null);
    }

    public long getCounter(String string, Integer n) {
        if (string == null) {
            log.error("null key for getCounter()");
            return -1L;
        }
        long l = -1L;
        try {
            l = Long.parseLong((String)this.get(string, n, true));
        }
        catch (Exception exception) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)exception, string);
            }
            log.info(String.format("Failed to parse Long value for key: %s", string));
        }
        return l;
    }

    public long addOrIncr(String string) {
        return this.client.addOrIncr(string);
    }

    public long addOrIncr(String string, long l) {
        return this.client.addOrIncr(string, l);
    }

    public long addOrIncr(String string, long l, Integer n) {
        return this.client.addOrIncr(string, l, n);
    }

    public long addOrDecr(String string) {
        return this.client.addOrDecr(string);
    }

    public long addOrDecr(String string, long l) {
        return this.client.addOrDecr(string, l);
    }

    public long addOrDecr(String string, long l, Integer n) {
        return this.client.addOrDecr(string, l, n);
    }

    public long incr(String string) {
        return this.client.incr(string);
    }

    public long incr(String string, long l) {
        return this.client.incr(string, l);
    }

    public long incr(String string, long l, Integer n) {
        return this.client.incr(string, l, n);
    }

    public long decr(String string) {
        return this.client.decr(string);
    }

    public long decr(String string, long l) {
        return this.client.decr(string, l);
    }

    public long decr(String string, long l, Integer n) {
        return this.client.decr(string, l, n);
    }

    public Object get(String string) {
        return this.client.get(string);
    }

    public Object get(String string, Integer n) {
        return this.client.get(string, n);
    }

    public MemcachedItem gets(String string) {
        return this.client.gets(string);
    }

    public MemcachedItem gets(String string, Integer n) {
        return this.client.gets(string, n);
    }

    public void setTransCoder(TransCoder transCoder) {
        this.client.setTransCoder(transCoder);
    }

    public Object get(String string, Integer n, boolean bl) {
        return this.client.get(string, n, bl);
    }

    public Object[] getMultiArray(String[] stringArray) {
        return this.client.getMultiArray(stringArray);
    }

    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray) {
        return this.client.getMultiArray(stringArray, integerArray);
    }

    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray, boolean bl) {
        return this.client.getMultiArray(stringArray, integerArray, bl);
    }

    public Map<String, Object> getMulti(String[] stringArray) {
        return this.getMulti(stringArray, null);
    }

    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray) {
        return this.client.getMulti(stringArray, integerArray);
    }

    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray, boolean bl) {
        return this.client.getMulti(stringArray, integerArray, bl);
    }

    public boolean flushAll() {
        return this.client.flushAll();
    }

    public boolean flushAll(String[] stringArray) {
        return this.client.flushAll(stringArray);
    }

    public Map<String, Map<String, String>> stats() {
        return this.client.stats();
    }

    public Map<String, Map<String, String>> stats(String[] stringArray) {
        return this.client.stats(stringArray);
    }

    public Map<String, Map<String, String>> statsItems() {
        return this.client.statsItems();
    }

    public Map<String, Map<String, String>> statsItems(String[] stringArray) {
        return this.client.statsItems(stringArray);
    }

    public Map<String, Map<String, String>> statsSlabs() {
        return this.client.statsSlabs();
    }

    public Map<String, Map<String, String>> statsSlabs(String[] stringArray) {
        return this.client.statsSlabs(stringArray);
    }

    public Map<String, Map<String, String>> statsCacheDump(int n, int n2) {
        return this.client.statsCacheDump(n, n2);
    }

    public Map<String, Map<String, String>> statsCacheDump(String[] stringArray, int n, int n2) {
        return this.client.statsCacheDump(stringArray, n, n2);
    }

    public boolean sync(String string, Integer n) {
        return this.client.sync(string, n);
    }

    public boolean sync(String string) {
        return this.client.sync(string);
    }

    public boolean syncAll() {
        return this.client.syncAll();
    }

    public boolean syncAll(String[] stringArray) {
        return this.client.syncAll(stringArray);
    }

    public boolean append(String string, Object object, Integer n) {
        return this.client.append(string, object, n);
    }

    public boolean append(String string, Object object) {
        return this.client.append(string, object);
    }

    public boolean cas(String string, Object object, Integer n, long l) {
        return this.client.cas(string, object, n, l);
    }

    public boolean cas(String string, Object object, Date date, long l) {
        return this.client.cas(string, object, date, l);
    }

    public boolean cas(String string, Object object, Date date, Integer n, long l) {
        return this.client.cas(string, object, date, n, l);
    }

    public boolean cas(String string, Object object, long l) {
        return this.client.cas(string, object, l);
    }

    public boolean prepend(String string, Object object, Integer n) {
        return this.client.prepend(string, object, n);
    }

    public boolean prepend(String string, Object object) {
        return this.client.prepend(string, object);
    }
}

