/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.danga.MemCached.Logger;
import com.schooner.MemCached.SchoonerSockIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;

public class SchoonerSockIOPool {
    private static Logger log = Logger.getLogger(SchoonerSockIOPool.class.getName());
    private static ConcurrentMap<String, SchoonerSockIOPool> pools = new ConcurrentHashMap<String, SchoonerSockIOPool>();
    private static ThreadLocal<MessageDigest> MD5 = new ThreadLocal<MessageDigest>(){

        @Override
        protected final MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                log.error("++++ no md5 algorithm found");
                throw new IllegalStateException("++++ no md5 algorythm found");
            }
        }
    };
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 600000L;
    boolean initialized = false;
    private int initConn = 1;
    private long maxBusyTime = 30000L;
    private long maintSleep = 30000L;
    private int socketTO = 30000;
    private int socketConnectTO = 3000;
    private static int recBufferSize = 128;
    private long maxIdle = 300000L;
    private boolean aliveCheck = false;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = false;
    private int hashingAlg = 0;
    private final ReentrantLock initDeadLock = new ReentrantLock();
    private String[] servers;
    private Integer[] weights;
    private Integer totalWeight = 0;
    private List<String> buckets;
    private TreeMap<Long, String> consistentBuckets;
    Map<String, ConcurrentLinkedQueue<SchoonerSockIO>> socketPool;
    private int maxConn = 32;
    private Map<String, AtomicInteger> poolCurrentConn;
    private boolean isTcp;
    private int bufferSize = 0x100400;

    protected SchoonerSockIOPool(boolean bl) {
        this.isTcp = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchoonerSockIOPool getInstance(String string) {
        ConcurrentMap<String, SchoonerSockIOPool> concurrentMap = pools;
        synchronized (concurrentMap) {
            if (!pools.containsKey(string)) {
                SchoonerSockIOPool schoonerSockIOPool = new SchoonerSockIOPool(true);
                pools.putIfAbsent(string, schoonerSockIOPool);
            }
        }
        return (SchoonerSockIOPool)pools.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchoonerSockIOPool getInstance(String string, boolean bl) {
        SchoonerSockIOPool schoonerSockIOPool;
        ConcurrentMap<String, SchoonerSockIOPool> concurrentMap = pools;
        synchronized (concurrentMap) {
            if (pools.containsKey(string)) {
                SchoonerSockIOPool schoonerSockIOPool2 = (SchoonerSockIOPool)pools.get(string);
                if (schoonerSockIOPool2.isTcp() == bl) {
                    return schoonerSockIOPool2;
                }
                return null;
            }
            schoonerSockIOPool = new SchoonerSockIOPool(bl);
            pools.putIfAbsent(string, schoonerSockIOPool);
        }
        return schoonerSockIOPool;
    }

    public static SchoonerSockIOPool getInstance() {
        return SchoonerSockIOPool.getInstance("default", true);
    }

    public static SchoonerSockIOPool getInstance(boolean bl) {
        return SchoonerSockIOPool.getInstance("default", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.initDeadLock.lock();
        try {
            if (this.servers == null || this.servers.length <= 0) {
                log.error("++++ trying to initialize with no servers");
                throw new IllegalStateException("++++ trying to initialize with no servers");
            }
            this.socketPool = new HashMap<String, ConcurrentLinkedQueue<SchoonerSockIO>>(this.servers.length);
            this.poolCurrentConn = new HashMap<String, AtomicInteger>(this.servers.length);
            if (this.hashingAlg == 3) {
                this.populateConsistentBuckets();
            } else {
                this.populateBuckets();
            }
            this.initialized = true;
        }
        finally {
            this.initDeadLock.unlock();
        }
    }

    public boolean isTcp() {
        return this.isTcp;
    }

    private void populateBuckets() {
        this.buckets = new ArrayList<String>();
        for (int i = 0; i < this.servers.length; ++i) {
            Object object;
            int n;
            if (this.weights != null && this.weights.length > i) {
                for (n = 0; n < this.weights[i]; ++n) {
                    this.buckets.add(this.servers[i]);
                }
            } else {
                this.buckets.add(this.servers[i]);
            }
            this.socketPool.put(this.servers[i], new ConcurrentLinkedQueue());
            for (n = 0; n < this.initConn; ++n) {
                object = this.createSocket(this.servers[i]);
                if (object == null) {
                    log.error("++++ failed to create connection to: " + this.servers[i] + " -- only " + n + " created.");
                    break;
                }
                this.addSocketToPool(this.servers[i], (SchoonerSockIO)object);
            }
            object = this.socketPool.get(this.servers[i]);
            AtomicInteger atomicInteger = new AtomicInteger(n);
            Iterator iterator = ((ConcurrentLinkedQueue)object).iterator();
            while (iterator.hasNext()) {
                SchoonerSockIO schoonerSockIO = (SchoonerSockIO)iterator.next();
                schoonerSockIO.setSockNum(atomicInteger);
            }
            this.poolCurrentConn.put(this.servers[i], atomicInteger);
        }
    }

    private void populateConsistentBuckets() {
        int n;
        this.consistentBuckets = new TreeMap();
        MessageDigest messageDigest = MD5.get();
        if (this.totalWeight <= 0 && this.weights != null) {
            for (n = 0; n < this.weights.length; ++n) {
                SchoonerSockIOPool schoonerSockIOPool = this;
                Integer.valueOf(schoonerSockIOPool.totalWeight + (this.weights[n] == null ? 1 : this.weights[n]));
                schoonerSockIOPool.totalWeight = schoonerSockIOPool.totalWeight;
            }
        } else if (this.weights == null) {
            this.totalWeight = this.servers.length;
        }
        for (n = 0; n < this.servers.length; ++n) {
            Object object;
            int n2;
            Object object2;
            Object object3;
            int n3 = 1;
            if (this.weights != null && this.weights[n] != null) {
                n3 = this.weights[n];
            }
            double d = Math.floor((double)(40 * this.servers.length * n3) / (double)this.totalWeight.intValue());
            long l = 0L;
            while ((double)l < d) {
                object3 = messageDigest.digest((this.servers[n] + "-" + l).getBytes());
                for (int i = 0; i < 4; ++i) {
                    object2 = (long)(object3[3 + i * 4] & 0xFF) << 24 | (long)(object3[2 + i * 4] & 0xFF) << 16 | (long)(object3[1 + i * 4] & 0xFF) << 8 | (long)(object3[0 + i * 4] & 0xFF);
                    this.consistentBuckets.put((Long)object2, this.servers[n]);
                }
                ++l;
            }
            this.socketPool.put(this.servers[n], new ConcurrentLinkedQueue());
            for (n2 = 0; n2 < this.initConn; ++n2) {
                object = this.createSocket(this.servers[n]);
                if (object == null) {
                    log.error("++++ failed to create connection to: " + this.servers[n] + " -- only " + n2 + " created.");
                    break;
                }
                this.addSocketToPool(this.servers[n], (SchoonerSockIO)object);
            }
            object = this.socketPool.get(this.servers[n]);
            object3 = new AtomicInteger(n2);
            Iterator iterator = ((ConcurrentLinkedQueue)object).iterator();
            while (iterator.hasNext()) {
                object2 = (SchoonerSockIO)iterator.next();
                ((SchoonerSockIO)object2).setSockNum((AtomicInteger)object3);
            }
            this.poolCurrentConn.put(this.servers[n], (AtomicInteger)object3);
        }
    }

    protected final SchoonerSockIO createSocket(String string) {
        SchoonerSockIO schoonerSockIO = null;
        try {
            schoonerSockIO = this.isTcp ? new TCPSockIO(this, string, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle) : new UDPSockIO(this, string, this.bufferSize, this.socketTO);
        }
        catch (Exception exception) {
            log.error("++++ failed to get SockIO obj for: " + string);
            schoonerSockIO = null;
        }
        return schoonerSockIO;
    }

    protected final SchoonerSockIO createSocketWithAdd(String string) {
        SchoonerSockIO schoonerSockIO = null;
        try {
            this.poolCurrentConn.get(string).addAndGet(1);
            schoonerSockIO = this.isTcp ? new TCPSockIO(this, string, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle) : new UDPSockIO(this, string, this.bufferSize, this.socketTO);
        }
        catch (Exception exception) {
            log.error("++++ failed to get SockIO obj for: " + string);
            schoonerSockIO = null;
            this.poolCurrentConn.get(string).decrementAndGet();
        }
        return schoonerSockIO;
    }

    public final String getHost(String string) {
        return this.getHost(string, null);
    }

    public final String getHost(String string, Integer n) {
        SchoonerSockIO schoonerSockIO = this.getSock(string, n);
        String string2 = schoonerSockIO.getHost();
        schoonerSockIO.close();
        return string2;
    }

    public final SchoonerSockIO getSock(String string) {
        return this.getSock(string, null);
    }

    public final SchoonerSockIO getSock(String string, Integer n) {
        String string2;
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        int n2 = 0;
        if (this.hashingAlg == 3 && this.consistentBuckets.size() == 0 || this.buckets != null && (n2 = this.buckets.size()) == 0) {
            return null;
        }
        if (n2 == 1) {
            SchoonerSockIO schoonerSockIO = this.hashingAlg == 3 ? this.getConnection(this.consistentBuckets.get(this.consistentBuckets.firstKey())) : this.getConnection(this.buckets.get(0));
            return schoonerSockIO;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.servers));
        long l = this.getBucket(string, n);
        String string3 = string2 = this.hashingAlg == 3 ? this.consistentBuckets.get(l) : this.buckets.get((int)l);
        while (!hashSet.isEmpty()) {
            SchoonerSockIO schoonerSockIO = this.getConnection(string2);
            if (schoonerSockIO != null) {
                return schoonerSockIO;
            }
            if (!this.failover) {
                return null;
            }
            hashSet.remove(string2);
            if (hashSet.isEmpty()) break;
            int n3 = 0;
            while (!hashSet.contains(string2)) {
                String string4 = new StringBuffer().append(n3).append(string).toString();
                l = this.getBucket(string4, null);
                string2 = this.hashingAlg == 3 ? this.consistentBuckets.get(l) : this.buckets.get((int)l);
                ++n3;
            }
        }
        return null;
    }

    public final SchoonerSockIO getConnection(String string) {
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (string == null) {
            return null;
        }
        ConcurrentLinkedQueue<SchoonerSockIO> concurrentLinkedQueue = this.socketPool.get(string);
        SchoonerSockIO schoonerSockIO = concurrentLinkedQueue.poll();
        if (schoonerSockIO == null) {
            if (this.poolCurrentConn.get(string).get() < this.maxConn) {
                schoonerSockIO = this.createSocketWithAdd(string);
            } else {
                schoonerSockIO = this.createSocket(string);
                if (schoonerSockIO == null) {
                    return null;
                }
                schoonerSockIO.setPooled(false);
            }
        } else if (this.aliveCheck && !schoonerSockIO.isAlive()) {
            schoonerSockIO = this.createSocket(string);
            if (schoonerSockIO == null) {
                return null;
            }
            schoonerSockIO.setPooled(false);
        }
        return schoonerSockIO;
    }

    protected final boolean addSocketToPool(String string, SchoonerSockIO schoonerSockIO) {
        ConcurrentLinkedQueue<SchoonerSockIO> concurrentLinkedQueue = this.socketPool.get(string);
        concurrentLinkedQueue.add(schoonerSockIO);
        return true;
    }

    protected final void closeSocketPool() {
        for (ConcurrentLinkedQueue<SchoonerSockIO> concurrentLinkedQueue : this.socketPool.values()) {
            for (SchoonerSockIO schoonerSockIO : concurrentLinkedQueue) {
                concurrentLinkedQueue.remove(schoonerSockIO);
                try {
                    schoonerSockIO.trueClose();
                }
                catch (IOException iOException) {
                    log.error("++++ failed to close socket: " + iOException.getMessage());
                }
                schoonerSockIO = null;
            }
        }
    }

    public void shutDown() {
        this.closeSocketPool();
        this.socketPool.clear();
        this.socketPool = null;
        this.buckets = null;
        this.consistentBuckets = null;
        this.initialized = false;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void setServers(String[] stringArray) {
        this.servers = stringArray;
    }

    public final String[] getServers() {
        return this.servers;
    }

    public final void setWeights(Integer[] integerArray) {
        this.weights = integerArray;
    }

    public final Integer[] getWeights() {
        return this.weights;
    }

    public final void setInitConn(int n) {
        this.initConn = n;
    }

    public final int getInitConn() {
        return this.initConn;
    }

    public final void setMaxBusyTime(long l) {
        this.maxBusyTime = l;
    }

    public final long getMaxBusy() {
        return this.maxBusyTime;
    }

    public void setMaintSleep(long l) {
        this.maintSleep = l;
    }

    public long getMaintSleep() {
        return this.maintSleep;
    }

    public final void setSocketTO(int n) {
        this.socketTO = n;
    }

    public final int getSocketTO() {
        return this.socketTO;
    }

    public final void setSocketConnectTO(int n) {
        this.socketConnectTO = n;
    }

    public final int getSocketConnectTO() {
        return this.socketConnectTO;
    }

    public void setMaxIdle(long l) {
        this.maxIdle = l;
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public final void setFailover(boolean bl) {
        this.failover = bl;
    }

    public final boolean getFailover() {
        return this.failover;
    }

    public void setFailback(boolean bl) {
        this.failback = bl;
    }

    public boolean getFailback() {
        return this.failback;
    }

    public final void setAliveCheck(boolean bl) {
        this.aliveCheck = bl;
    }

    public final boolean getAliveCheck() {
        return this.aliveCheck;
    }

    public final void setNagle(boolean bl) {
        this.nagle = bl;
    }

    public final boolean getNagle() {
        return this.nagle;
    }

    public final void setHashingAlg(int n) {
        this.hashingAlg = n;
    }

    public final int getHashingAlg() {
        return this.hashingAlg;
    }

    private static long origCompatHashingAlg(String string) {
        long l = 0L;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            l = l * 33L + (long)cArray[i];
        }
        return l;
    }

    private static long newCompatHashingAlg(String string) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        long l = cRC32.getValue();
        return l >> 16 & 0x7FFFL;
    }

    private static long md5HashingAlg(String string) {
        MessageDigest messageDigest = MD5.get();
        messageDigest.reset();
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        long l = (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
        return l;
    }

    private final long getHash(String string, Integer n) {
        if (n != null) {
            if (this.hashingAlg == 3) {
                return n.longValue() & 0xFFFFFFFFL;
            }
            return n.longValue();
        }
        switch (this.hashingAlg) {
            case 0: {
                return string.hashCode();
            }
            case 1: {
                return SchoonerSockIOPool.origCompatHashingAlg(string);
            }
            case 2: {
                return SchoonerSockIOPool.newCompatHashingAlg(string);
            }
            case 3: {
                return SchoonerSockIOPool.md5HashingAlg(string);
            }
        }
        this.hashingAlg = 0;
        return string.hashCode();
    }

    private final long getBucket(String string, Integer n) {
        long l = this.getHash(string, n);
        if (this.hashingAlg == 3) {
            return this.findPointFor(l);
        }
        long l2 = l % (long)this.buckets.size();
        if (l2 < 0L) {
            l2 *= -1L;
        }
        return l2;
    }

    private final Long findPointFor(Long l) {
        SortedMap<Long, String> sortedMap = this.consistentBuckets.tailMap(l);
        return sortedMap.isEmpty() ? this.consistentBuckets.firstKey() : sortedMap.firstKey();
    }

    public void setMaxConn(int n) {
        this.maxConn = n;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMinConn(int n) {
        this.initConn = n;
    }

    public int getMinConn() {
        return this.initConn;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public static class TCPSockIO
    extends SchoonerSockIO {
        private static Logger log = Logger.getLogger(SchoonerSockIO.class.getName());
        private String host;
        private Socket sock;
        public SocketChannel sockChannel;
        private int hash = 0;

        public TCPSockIO(SchoonerSockIOPool schoonerSockIOPool, String string, int n, int n2, int n3, boolean bl) throws IOException, UnknownHostException {
            super(n);
            String[] stringArray = string.split(":");
            this.sock = TCPSockIO.getSocket(stringArray[0], Integer.parseInt(stringArray[1]), n3);
            this.writeBuf = ByteBuffer.allocateDirect(n);
            if (n2 >= 0) {
                this.sock.setSoTimeout(n2);
            }
            this.sock.setTcpNoDelay(bl);
            this.sockChannel = this.sock.getChannel();
            this.hash = this.sock.hashCode();
            this.host = string;
            this.sockets = schoonerSockIOPool.socketPool.get(string);
            this.sockNum = (AtomicInteger)schoonerSockIOPool.poolCurrentConn.get(string);
        }

        protected static final Socket getSocket(String string, int n, int n2) throws IOException {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.socket().connect(new InetSocketAddress(string, n), n2);
            return socketChannel.socket();
        }

        public final SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        public final String getHost() {
            return this.host;
        }

        public final void trueClose() throws IOException {
            this.readBuf.clear();
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.sockChannel == null || this.sock == null) {
                bl = true;
                stringBuilder.append("++++ socket or its streams already null in trueClose call");
            }
            if (this.sockChannel != null) {
                try {
                    this.sockChannel.close();
                }
                catch (IOException iOException) {
                    log.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(iOException.getMessage(), iOException);
                    stringBuilder.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    stringBuilder.append(iOException.getMessage());
                    bl = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    log.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(iOException.getMessage(), iOException);
                    stringBuilder.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    stringBuilder.append(iOException.getMessage());
                    bl = true;
                }
            }
            this.sockChannel = null;
            this.sock = null;
            if (this.isPooled) {
                this.sockNum.decrementAndGet();
            }
            if (bl) {
                throw new IOException(stringBuilder.toString());
            }
        }

        public final void close() {
            this.readBuf.clear();
            if (this.isPooled) {
                this.sockets.add(this);
            }
        }

        public boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        public final boolean isAlive() {
            if (!this.isConnected()) {
                return false;
            }
            try {
                this.write("version\r\n".getBytes());
                this.readBuf.clear();
                this.sockChannel.read(this.readBuf);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }

        public final void readBytes(int n) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            while (n > 0) {
                int n2 = this.sockChannel.read(this.readBuf);
                n -= n2;
            }
        }

        public void write(byte[] byArray) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.sockChannel.write(ByteBuffer.wrap(byArray));
        }

        public void flush() throws IOException {
            this.writeBuf.flip();
            this.sockChannel.write(this.writeBuf);
        }

        public final int hashCode() {
            return this.sock == null ? 0 : this.hash;
        }

        public final String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
            finally {
                super.finalize();
            }
        }

        public short preWrite() {
            return 0;
        }

        public byte[] getResponse(short s) throws IOException {
            return null;
        }

        public void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] byArray = new byte[1];
            boolean bl = false;
            InputStream inputStream = this.sock.getInputStream();
            while (inputStream.read(byArray, 0, 1) != -1) {
                if (byArray[0] == 13) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (byArray[0] == 10) break;
                bl = false;
            }
        }

        public int read(byte[] byArray) throws IOException {
            int n;
            int n2;
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            InputStream inputStream = this.sock.getInputStream();
            for (n = 0; n < byArray.length; n += n2) {
                n2 = inputStream.read(byArray, n, byArray.length - n);
            }
            return n;
        }

        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] byArray = new byte[1];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            InputStream inputStream = this.sock.getInputStream();
            while (inputStream.read(byArray, 0, 1) != -1) {
                if (byArray[0] == 13) {
                    bl = true;
                } else if (bl) {
                    if (byArray[0] == 10) break;
                    bl = false;
                }
                byteArrayOutputStream.write(byArray, 0, 1);
            }
            if (byteArrayOutputStream == null || byteArrayOutputStream.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return byteArrayOutputStream.toString().trim();
        }

        public void trueClose(boolean bl) throws IOException {
            this.trueClose();
        }

        public ByteChannel getByteChannel() {
            return null;
        }
    }

    public static class UDPSockIO
    extends SchoonerSockIO {
        public static Short REQUESTID = 0;
        public static final short SEQENCE = 0;
        public static final short TOTAL = 1;
        public static final short RESERVED = 0;
        private static ConcurrentMap<String, byte[]> data = new ConcurrentHashMap<String, byte[]>();
        public static ConcurrentMap<Short, UDPDataItem> dataStore = new ConcurrentHashMap<Short, UDPDataItem>();
        public DatagramChannel channel;
        private Selector selector;

        public void trueClose() throws IOException {
            if (this.selector != null) {
                this.selector.close();
                this.channel.close();
            }
            if (this.isPooled) {
                this.sockNum.decrementAndGet();
            }
        }

        public UDPSockIO(SchoonerSockIOPool schoonerSockIOPool, String string, int n, int n2) throws IOException, UnknownHostException {
            super(n);
            String[] stringArray = string.split(":");
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(stringArray[0], Integer.parseInt(stringArray[1]));
            this.channel.connect(inetSocketAddress);
            this.channel.socket().setSoTimeout(n2);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            this.writeBuf = ByteBuffer.allocateDirect(n);
            this.sockets = schoonerSockIOPool.socketPool.get(string);
            this.sockNum = (AtomicInteger)schoonerSockIOPool.poolCurrentConn.get(string);
        }

        public ByteChannel getByteChannel() {
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short preWrite() {
            this.writeBuf.clear();
            short s = 0;
            Short s2 = REQUESTID;
            synchronized (s2) {
                Short s3 = REQUESTID;
                Short s4 = REQUESTID = Short.valueOf((short)(REQUESTID + 1));
                s = REQUESTID;
            }
            this.writeBuf.putShort(s);
            this.writeBuf.putShort((short)0);
            this.writeBuf.putShort((short)1);
            this.writeBuf.putShort((short)0);
            return s;
        }

        public byte[] getResponse(short s) throws IOException {
            Object object;
            int n;
            long l;
            long l2 = l = 1000L;
            int n2 = 0;
            byte[] byArray = null;
            UDPDataItem uDPDataItem = new UDPDataItem();
            dataStore.put(s, uDPDataItem);
            long l3 = System.currentTimeMillis();
            while (l2 > 0L && !uDPDataItem.isFinished() && (n = this.selector.select(500L)) > 0) {
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                block1: while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isReadable()) continue;
                    object = (DatagramChannel)selectionKey.channel();
                    while (true) {
                        this.readBuf.clear();
                        ((DatagramChannel)object).read(this.readBuf);
                        n2 = this.readBuf.position();
                        if (n2 <= 8) continue block1;
                        this.readBuf.flip();
                        short s2 = this.readBuf.getShort();
                        UDPDataItem uDPDataItem2 = (UDPDataItem)dataStore.get(s2);
                        if (uDPDataItem2 == null || uDPDataItem2.isFinished) continue;
                        uDPDataItem2.addLength(n2 - 8);
                        short s3 = this.readBuf.getShort();
                        uDPDataItem2.setTotal(this.readBuf.getShort());
                        this.readBuf.getShort();
                        byte[] byArray2 = new byte[n2 - 8];
                        this.readBuf.get(byArray2);
                        uDPDataItem2.incrCounter();
                        data.put(s2 + "_" + s3, byArray2);
                        if (uDPDataItem2.getCounter() != uDPDataItem2.getTotal()) continue;
                        uDPDataItem2.setFinished(true);
                    }
                }
                l2 = l - (System.currentTimeMillis() - l3);
            }
            if (!uDPDataItem.isFinished) {
                dataStore.remove(s);
                for (n = 0; n < uDPDataItem.getTotal(); n = (int)((short)(n + 1))) {
                    data.remove(s + "_" + n);
                }
                return null;
            }
            n = uDPDataItem.getLength();
            byArray = new byte[n];
            n = 0;
            boolean bl = true;
            for (short s4 = 0; s4 < uDPDataItem.getTotal(); s4 = (short)(s4 + 1)) {
                object = (byte[])data.remove(s + "_" + s4);
                if (object == null) {
                    bl = false;
                }
                if (!bl) continue;
                System.arraycopy(object, 0, byArray, n, ((Object)object).length);
                n += ((Object)object).length;
            }
            dataStore.remove(s);
            if (!bl) {
                return null;
            }
            return byArray;
        }

        public void close() {
            this.readBuf.clear();
            this.writeBuf.clear();
            if (this.isPooled) {
                this.sockets.add(this);
            }
        }

        public String getHost() {
            return this.channel.socket().getInetAddress().getHostName();
        }

        public void clearEOL() throws IOException {
        }

        public int read(byte[] byArray) {
            return 0;
        }

        public String readLine() throws IOException {
            return null;
        }

        public void trueClose(boolean bl) throws IOException {
        }

        public SocketChannel getChannel() {
            return null;
        }

        private class UDPDataItem {
            private short counter = 0;
            private boolean isFinished = false;
            private int length = 0;
            private short total;

            private UDPDataItem() {
            }

            public synchronized short getTotal() {
                return this.total;
            }

            public synchronized void setTotal(short s) {
                if (this.total == 0) {
                    this.total = s;
                }
            }

            public synchronized short getCounter() {
                return this.counter;
            }

            public synchronized short incrCounter() {
                this.counter = (short)(this.counter + 1);
                return this.counter;
            }

            public synchronized boolean isFinished() {
                return this.isFinished;
            }

            public synchronized void setFinished(boolean bl) {
                this.isFinished = bl;
            }

            public synchronized int getLength() {
                return this.length;
            }

            public synchronized void addLength(int n) {
                this.length += n;
            }
        }
    }
}

