/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.danga.MemCached.Logger;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.command.Command;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class DeletionCommand
extends Command {
    private static Logger log = Logger.getLogger(DeletionCommand.class.getName(), 4);
    private static final byte[] DELETED = "DELETED\r\n".getBytes();
    private static final byte[] NOTFOUND = "NOT_FOUND\r\n".getBytes();

    public DeletionCommand(String string, Integer n, Date date) {
        StringBuilder stringBuilder = new StringBuilder("delete").append(" ").append(string);
        if (date != null) {
            stringBuilder.append(" " + date.getTime() / 1000L);
        }
        stringBuilder.append("\r\n");
        this.textLine = stringBuilder.toString().getBytes();
    }

    public boolean response(SchoonerSockIO schoonerSockIO, short s) throws IOException {
        byte[] byArray = schoonerSockIO.getResponse(s);
        if (Arrays.equals(byArray, DELETED)) {
            if (log.isInfoEnabled()) {
                log.info("DELETED!");
            }
            return true;
        }
        if (Arrays.equals(byArray, NOTFOUND)) {
            if (log.isInfoEnabled()) {
                log.info("NOT_FOUND!");
            }
        } else {
            log.error("error");
        }
        return false;
    }
}

