/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.danga.MemCached.Logger;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.Command;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class RetrievalCommand
extends Command {
    private static Logger log = Logger.getLogger(RetrievalCommand.class.getName(), 4);
    private static final byte[] B_END = "END\r\n".getBytes();
    private static final byte[] B_VALUE = "VALUE ".getBytes();
    private String key;
    private String cmd;

    public RetrievalCommand(String string, String string2) {
        this.key = string2;
        this.cmd = string;
        StringBuilder stringBuilder = new StringBuilder(string).append(" ").append(string2).append("\r\n");
        this.textLine = stringBuilder.toString().getBytes();
    }

    public MemcachedItem response(SchoonerSockIO schoonerSockIO, TransCoder transCoder, short s) throws IOException {
        byte[] byArray = schoonerSockIO.getResponse(s);
        MemcachedItem memcachedItem = new MemcachedItem();
        if (byArray == null) {
            return memcachedItem;
        }
        ResponseParser responseParser = new ResponseParser();
        responseParser.exec(byArray);
        if (responseParser.retvalue != null) {
            Value value = responseParser.retvalue;
            if (this.cmd.equals("gets")) {
                memcachedItem.casUnique = value.casUnique;
            }
            try {
                if (NativeHandler.isHandled(value.flags)) {
                    memcachedItem.value = NativeHandler.decode(value.dataBlock, value.flags);
                } else if (transCoder != null) {
                    memcachedItem.value = transCoder.decode(new ByteArrayInputStream(value.dataBlock));
                }
            }
            catch (IOException iOException) {
                log.error("error happend in decoding the object");
                throw iOException;
            }
            return memcachedItem;
        }
        return memcachedItem;
    }

    public class ResponseParser {
        private LinkedList<Value> list;
        public Value retvalue = null;

        public void exec(byte[] byArray) throws IOException {
            Value value;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray2 = new byte[5];
            int n = 0;
            int n2 = 0;
            byteArrayInputStream.mark(0);
            byteArrayInputStream.read(byArray2);
            if (Arrays.equals(byArray2, B_END)) {
                return;
            }
            byteArrayInputStream.reset();
            while (true) {
                byte by;
                value = new Value();
                byteArrayInputStream.skip(B_VALUE.length + RetrievalCommand.this.key.length() + 1);
                n = 0;
                while ((by = (byte)byteArrayInputStream.read()) != 32) {
                    ++n;
                    stringBuilder.append((char)by);
                }
                try {
                    value.flags = Integer.valueOf(stringBuilder.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.retvalue = null;
                    return;
                }
                stringBuilder.delete(0, n);
                n = 0;
                while ((by = (byte)byteArrayInputStream.read()) != 32 && by != 13) {
                    ++n;
                    stringBuilder.append((char)by);
                }
                try {
                    value.bytes = Integer.valueOf(stringBuilder.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.retvalue = null;
                    return;
                }
                stringBuilder.delete(0, n);
                if (RetrievalCommand.this.cmd.equals("gets")) {
                    n = 0;
                    while ((by = (byte)byteArrayInputStream.read()) != 13) {
                        ++n;
                        stringBuilder.append((char)by);
                    }
                    try {
                        value.casUnique = Long.valueOf(stringBuilder.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.retvalue = null;
                        return;
                    }
                    stringBuilder.delete(0, n);
                }
                byteArrayInputStream.skip(1L);
                value.dataBlock = new byte[value.bytes];
                byteArrayInputStream.read(value.dataBlock);
                byteArrayInputStream.skip(2L);
                byteArrayInputStream.mark(0);
                byteArrayInputStream.read(byArray2);
                if (Arrays.equals(byArray2, B_END)) break;
                byteArrayInputStream.reset();
                if (n2 == 0) {
                    this.list = new LinkedList();
                }
                this.list.add(value);
                ++n2;
            }
            this.retvalue = value;
        }
    }

    public class Value {
        public int flags;
        public int bytes;
        public long casUnique;
        public byte[] dataBlock;
    }
}

