/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemImpl
implements Item {
    private static Logger log = LoggerFactory.getLogger((Class)ItemImpl.class);
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_MODIFIED = 1;
    protected static final int STATUS_DESTROYED = 2;
    protected static final int STATUS_INVALIDATED = 3;
    protected final ItemId id;
    protected final SessionImpl session;
    protected final RepositoryImpl rep;
    protected final ItemData data;
    protected final ItemManager itemMgr;
    protected final SessionItemStateManager stateMgr;

    ItemImpl(ItemManager itemMgr, SessionImpl session, ItemData data) {
        this.session = session;
        this.rep = (RepositoryImpl)session.getRepository();
        this.stateMgr = session.getItemStateManager();
        this.id = data.getId();
        this.itemMgr = itemMgr;
        this.data = data;
    }

    protected void sanityCheck() throws RepositoryException {
        this.session.sanityCheck();
        int status = this.data.getStatus();
        if (status == 2 || status == 3) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
    }

    protected boolean isTransient() {
        return this.getItemState().isTransient();
    }

    protected abstract ItemState getOrCreateTransientItemState() throws RepositoryException;

    protected abstract void makePersistent() throws InvalidItemStateException;

    protected void setRemoved() throws RepositoryException {
        int status = this.data.getStatus();
        if (status == 3 || status == 2) {
            return;
        }
        ItemState transientState = this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4) {
            this.stateMgr.disposeTransientItemState(transientState);
        } else {
            transientState.setStatus(3);
            this.stateMgr.moveTransientItemStateToAttic(transientState);
            this.data.setStatus(3);
            this.itemMgr.itemInvalidated(this.id, this.data);
        }
    }

    ItemState getItemState() {
        return this.data.getState();
    }

    public ItemId getId() {
        return this.id;
    }

    public Path getPrimaryPath() throws RepositoryException {
        return this.session.getHierarchyManager().getPath(this.id);
    }

    private Collection getTransientStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> dirty = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block13: while (iter.hasNext()) {
                ItemState transientState = (ItemState)iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: {
                        dirty.add(transientState);
                        continue block13;
                    }
                    case 5: {
                        throw new InvalidItemStateException("Item cannot be saved because it has been modified externally: " + this);
                    }
                    case 6: {
                        throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally: " + this);
                    }
                    case 0: {
                        throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                    }
                }
                log.warn("Unexpected item state status: " + transientState.getStatus() + " of " + this);
            }
        }
        if (this.isTransient()) {
            ItemState state = this.getItemState();
            switch (state.getStatus()) {
                case 2: {
                    dirty.add(state);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot save a new item: " + this);
                }
                case 5: {
                    throw new InvalidItemStateException("Item cannot be saved because it has been modified externally: " + this);
                }
                case 6: {
                    throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally:" + this);
                }
                case 0: {
                    throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                }
                default: {
                    log.warn("Unexpected item state status:" + state.getStatus() + " of " + this);
                }
            }
        }
        return dirty;
    }

    private Collection getRemovedStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> removed = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                ItemState transientState = (ItemState)iter.next();
                if (transientState.getStatus() == 5) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has been modified externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (transientState.getStatus() == 6) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has already been deleted externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                removed.add(transientState);
            }
        }
        return removed;
    }

    private void validateTransientItems(Iterator dirtyIter, Iterator removedIter) throws AccessDeniedException, ConstraintViolationException, RepositoryException {
        String msg;
        Path path;
        ItemDefinitionImpl def;
        ItemState itemState;
        AccessManager accessMgr = this.session.getAccessManager();
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        while (dirtyIter.hasNext()) {
            String[] constraints;
            String msg2;
            itemState = (ItemState)dirtyIter.next();
            def = itemState.isNode() ? this.itemMgr.getDefinition((NodeState)itemState) : this.itemMgr.getDefinition((PropertyState)itemState);
            if (!def.isProtected()) {
                path = this.stateMgr.getHierarchyMgr().getPath(itemState.getId());
                boolean isGranted = true;
                if (itemState.isNode()) {
                    if (itemState.getStatus() == 4) {
                        isGranted = accessMgr.isGranted(path, 4);
                    }
                } else {
                    isGranted = accessMgr.isGranted(path, 2);
                }
                if (!isGranted) {
                    msg = this.itemMgr.safeGetJCRPath(path) + ": not allowed to add or modify item";
                    log.debug(msg);
                    throw new AccessDeniedException(msg);
                }
            }
            if (itemState.isNode()) {
                String msg3;
                int i;
                NodeState nodeState = (NodeState)itemState;
                NodeId id = nodeState.getNodeId();
                NodeDefinition nodeDef = def;
                NodeTypeImpl pnt = ntMgr.getNodeType(nodeState.getNodeTypeName());
                EffectiveNodeType ent = this.getEffectiveNodeType(nodeState);
                if (nodeState.getStatus() == 4 || !nodeState.getNodeTypeName().equals(((NodeState)nodeState.getOverlayedState()).getNodeTypeName())) {
                    NodeType[] nta = nodeDef.getRequiredPrimaryTypes();
                    for (i = 0; i < nta.length; ++i) {
                        NodeTypeImpl ntReq = (NodeTypeImpl)nta[i];
                        if (pnt.getQName().equals(ntReq.getQName()) || pnt.isDerivedFrom(ntReq.getQName())) continue;
                        msg3 = this.itemMgr.safeGetJCRPath(id) + " must be of node type " + ntReq.getName();
                        log.debug(msg3);
                        throw new ConstraintViolationException(msg3);
                    }
                }
                PropDef[] pda = ent.getMandatoryPropDefs();
                for (i = 0; i < pda.length; ++i) {
                    PropDef pd = pda[i];
                    if (pd.getDeclaringNodeType().equals(NameConstants.MIX_VERSIONABLE) || pd.getDeclaringNodeType().equals(NameConstants.MIX_SIMPLE_VERSIONABLE) || nodeState.hasPropertyName(pd.getName())) continue;
                    msg3 = this.itemMgr.safeGetJCRPath(id) + ": mandatory property " + pd.getName() + " does not exist";
                    log.debug(msg3);
                    throw new ConstraintViolationException(msg3);
                }
                NodeDef[] cnda = ent.getMandatoryNodeDefs();
                for (int i2 = 0; i2 < cnda.length; ++i2) {
                    NodeDef cnd = cnda[i2];
                    if (nodeState.hasChildNodeEntry(cnd.getName())) continue;
                    msg2 = this.itemMgr.safeGetJCRPath(id) + ": mandatory child node " + cnd.getName() + " does not exist";
                    log.debug(msg2);
                    throw new ConstraintViolationException(msg2);
                }
                continue;
            }
            PropertyState propState = (PropertyState)itemState;
            PropertyId propId = propState.getPropertyId();
            PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)def;
            if (def.isProtected() || (constraints = propDef.getValueConstraints()) == null) continue;
            InternalValue[] values = propState.getValues();
            try {
                EffectiveNodeType.checkSetPropertyValueConstraints(propDef.unwrap(), values);
            }
            catch (RepositoryException e) {
                String msg4 = this.itemMgr.safeGetJCRPath(propId) + ": " + e.getMessage();
                log.debug(msg4);
                throw new ConstraintViolationException(msg4);
            }
            if (constraints.length <= 0 || propDef.getRequiredType() != 9) continue;
            for (int i = 0; i < values.length; ++i) {
                boolean satisfied = false;
                String constraintViolationMsg = null;
                try {
                    UUID targetUUID = values[i].getUUID();
                    Node targetNode = this.session.getNodeByUUID(targetUUID);
                    for (int j = 0; j < constraints.length; ++j) {
                        String ntName = constraints[j];
                        if (!targetNode.isNodeType(ntName)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        NodeType[] mixinNodeTypes = targetNode.getMixinNodeTypes();
                        String[] targetMixins = new String[mixinNodeTypes.length];
                        for (int j = 0; j < mixinNodeTypes.length; ++j) {
                            targetMixins[j] = mixinNodeTypes[j].getName();
                        }
                        String targetMixinsString = Text.implode((String[])targetMixins, (String)", ");
                        String constraintsString = Text.implode((String[])constraints, (String)", ");
                        constraintViolationMsg = this.itemMgr.safeGetJCRPath(propId) + ": is constraint to [" + constraintsString + "] but references [primaryType=" + targetNode.getPrimaryNodeType().getName() + ", mixins=" + targetMixinsString + "]";
                    }
                }
                catch (RepositoryException re) {
                    msg2 = this.itemMgr.safeGetJCRPath(propId) + ": failed to check REFERENCE value constraint";
                    log.debug(msg2);
                    throw new ConstraintViolationException(msg2, (Throwable)re);
                }
                if (satisfied) continue;
                log.debug(constraintViolationMsg);
                throw new ConstraintViolationException(constraintViolationMsg);
            }
        }
        while (removedIter.hasNext()) {
            int permission;
            itemState = (ItemState)removedIter.next();
            try {
                def = itemState.isNode() ? this.itemMgr.getDefinition((NodeState)itemState) : this.itemMgr.getDefinition((PropertyState)itemState);
            }
            catch (ConstraintViolationException e) {
                continue;
            }
            if (def.isProtected() || accessMgr.isGranted(path = this.stateMgr.getAtticAwareHierarchyMgr().getPath(itemState.getId()), permission = itemState.isNode() ? 8 : 16)) continue;
            msg = this.itemMgr.safeGetJCRPath(path) + ": not allowed to remove item";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
    }

    private void removeTransientItems(Iterator iter) {
        while (iter.hasNext()) {
            ItemState transientState = (ItemState)iter.next();
            ItemState persistentState = transientState.getOverlayedState();
            this.stateMgr.destroy(persistentState);
        }
    }

    private void persistTransientItems(Iterator iter) throws RepositoryException {
        while (iter.hasNext()) {
            ItemState state = (ItemState)iter.next();
            ItemImpl item = this.itemMgr.getItem(state.getId());
            item.makePersistent();
        }
    }

    private void restoreTransientItems(Iterator iter) {
        while (iter.hasNext()) {
            ItemState itemState = (ItemState)iter.next();
            ItemId id = itemState.getId();
            try {
                ItemImpl item;
                if (this.stateMgr.isItemStateInAttic(id)) {
                    item = this.itemMgr.createItemInstance(itemState);
                    itemState.setStatus(4);
                } else {
                    try {
                        item = this.itemMgr.getItem(id);
                    }
                    catch (ItemNotFoundException infe) {
                        item = this.itemMgr.createItemInstance(itemState);
                        itemState.setStatus(4);
                    }
                }
                if (item.isNode()) {
                    NodeImpl node = (NodeImpl)item;
                    node.restoreTransient((NodeState)itemState);
                    continue;
                }
                PropertyImpl prop = (PropertyImpl)item;
                prop.restoreTransient((PropertyState)itemState);
            }
            catch (RepositoryException re) {
                String msg = this.itemMgr.safeGetJCRPath(id) + ": failed to restore transient state";
                log.warn(msg, (Throwable)re);
            }
        }
    }

    private void processShareableNodes(Iterator iter) throws RepositoryException {
        while (iter.hasNext()) {
            ItemState is = (ItemState)iter.next();
            if (!is.isNode()) continue;
            NodeState ns = (NodeState)is;
            boolean wasShareable = false;
            if (ns.hasOverlayedState()) {
                NodeState old = (NodeState)ns.getOverlayedState();
                EffectiveNodeType ntOld = this.getEffectiveNodeType(old);
                wasShareable = ntOld.includesNodeType(NameConstants.MIX_SHAREABLE);
            }
            EffectiveNodeType ntNew = this.getEffectiveNodeType(ns);
            boolean isShareable = ntNew.includesNodeType(NameConstants.MIX_SHAREABLE);
            if (!wasShareable && isShareable) {
                ns.addShare(ns.getParentId());
                continue;
            }
            if (!wasShareable || isShareable) continue;
            String msg = "Removing mix:shareable is not supported.";
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
    }

    private boolean initVersionHistories(Iterator iter) throws RepositoryException {
        boolean createdTransientState = false;
        while (iter.hasNext()) {
            ItemState itemState = (ItemState)iter.next();
            if (!itemState.isNode()) continue;
            NodeState nodeState = (NodeState)itemState;
            EffectiveNodeType nt = this.getEffectiveNodeType(nodeState);
            if (nt.includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                if (nodeState.hasPropertyName(NameConstants.JCR_VERSIONHISTORY)) continue;
                NodeImpl node = (NodeImpl)this.itemMgr.getItem(itemState.getId());
                VersionManager vMgr = this.session.getVersionManager();
                VersionHistoryInfo history = vMgr.getVersionHistory((Session)this.session, nodeState);
                InternalValue historyId = InternalValue.create(history.getVersionHistoryId().getUUID());
                InternalValue versionId = InternalValue.create(history.getRootVersionId().getUUID());
                node.internalSetProperty(NameConstants.JCR_VERSIONHISTORY, historyId);
                node.internalSetProperty(NameConstants.JCR_BASEVERSION, versionId);
                node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
                node.internalSetProperty(NameConstants.JCR_PREDECESSORS, new InternalValue[]{versionId});
                createdTransientState = true;
                continue;
            }
            if (!nt.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) continue;
            VersionManager vMgr = this.session.getVersionManager();
            vMgr.getVersionHistory((Session)this.session, nodeState);
            NodeImpl node = (NodeImpl)this.itemMgr.getItem(itemState.getId());
            if (nodeState.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) continue;
            node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
            createdTransientState = true;
        }
        return createdTransientState;
    }

    private EffectiveNodeType getEffectiveNodeType(NodeState state) throws RepositoryException {
        try {
            NodeTypeRegistry registry = this.session.getNodeTypeManager().getNodeTypeRegistry();
            return registry.getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException e) {
            throw new RepositoryException("Failed to build effective node type of node state " + state.getId(), (Throwable)e);
        }
    }

    public String safeGetJCRPath() {
        return this.itemMgr.safeGetJCRPath(this.id);
    }

    protected void internalRemove(boolean noChecks) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        if (this.getDepth() == 0) {
            throw new RepositoryException("Cannot remove the root node");
        }
        NodeImpl parentNode = (NodeImpl)this.getParent();
        if (!noChecks) {
            int options = 400;
            this.session.getValidator().checkRemove(this, options, 0);
            options = 22;
            this.session.getValidator().checkModify(parentNode, options, 0);
        }
        if (this.isNode()) {
            parentNode.removeChildNode((NodeId)this.getId());
        } else {
            Path.Element thisName = this.getPrimaryPath().getNameElement();
            parentNode.removeChildProperty(thisName.getName());
        }
    }

    public abstract Name getQName() throws RepositoryException;

    public abstract void accept(ItemVisitor var1) throws RepositoryException;

    public abstract boolean isNode();

    public abstract String getName() throws RepositoryException;

    public abstract Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException;

    public boolean isNew() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() == null;
    }

    protected boolean isTransactionalNew() {
        ItemState state = this.getItemState();
        return state.getStatus() == 4;
    }

    public boolean isModified() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() != null;
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.internalRemove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        SessionImpl sessionImpl = this.session;
        synchronized (sessionImpl) {
            ItemState transientState;
            Iterator it;
            Collection dirty;
            try {
                dirty = this.getTransientStates();
            }
            catch (ConcurrentModificationException e) {
                String msg = "Concurrent modification; session is closed";
                log.error(msg, (Throwable)e);
                this.session.logout();
                throw e;
            }
            if (dirty.size() == 0) {
                return;
            }
            Collection removed = this.getRemovedStates();
            HashSet<ItemId> affectedIds = new HashSet<ItemId>(dirty.size() + removed.size());
            IteratorChain it2 = new IteratorChain(dirty.iterator(), removed.iterator());
            while (it2.hasNext()) {
                affectedIds.add(((ItemState)it2.next()).getId());
            }
            it2 = new IteratorChain(dirty.iterator(), removed.iterator());
            while (it2.hasNext()) {
                ChildNodeEntry cne;
                ItemState transientState2 = (ItemState)it2.next();
                if (!transientState2.isNode()) continue;
                NodeState nodeState = (NodeState)transientState2;
                HashSet<NodeId> dependentIDs = new HashSet<NodeId>();
                if (nodeState.hasOverlayedState()) {
                    NodeState overlayedState = (NodeState)nodeState.getOverlayedState();
                    NodeId oldParentId = overlayedState.getParentId();
                    NodeId newParentId = nodeState.getParentId();
                    if (oldParentId != null) {
                        if (newParentId == null) {
                            if (overlayedState.isShareable()) {
                                dependentIDs.addAll(overlayedState.getSharedSet());
                            } else {
                                dependentIDs.add(oldParentId);
                            }
                        } else if (!oldParentId.equals(newParentId)) {
                            dependentIDs.add(oldParentId);
                            dependentIDs.add(newParentId);
                        } else if (!affectedIds.contains(newParentId) && this.stateMgr.hasTransientItemState(newParentId)) {
                            try {
                                NodeState parent = (NodeState)this.stateMgr.getTransientItemState(newParentId);
                                Iterator cneIt = parent.getRenamedChildNodeEntries().iterator();
                                while (cneIt.hasNext()) {
                                    ChildNodeEntry cne2 = (ChildNodeEntry)cneIt.next();
                                    if (!cne2.getId().equals(nodeState.getId())) continue;
                                    dependentIDs.add(newParentId);
                                }
                            }
                            catch (ItemStateException ise) {
                                log.warn("failed to retrieve transient state: " + newParentId, (Throwable)ise);
                            }
                        }
                    }
                }
                Iterator cneIt = nodeState.getRemovedChildNodeEntries().iterator();
                while (cneIt.hasNext()) {
                    cne = (ChildNodeEntry)cneIt.next();
                    dependentIDs.add(cne.getId());
                }
                cneIt = nodeState.getAddedChildNodeEntries().iterator();
                while (cneIt.hasNext()) {
                    cne = (ChildNodeEntry)cneIt.next();
                    dependentIDs.add(cne.getId());
                }
                Iterator depIt = dependentIDs.iterator();
                while (depIt.hasNext()) {
                    NodeId id = (NodeId)depIt.next();
                    if (affectedIds.contains(id) || !this.stateMgr.hasTransientItemState(id) && !this.stateMgr.hasTransientItemStateInAttic(id)) continue;
                    String msg = this.itemMgr.safeGetJCRPath(id) + " needs to be saved as well.";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            this.validateTransientItems(dirty.iterator(), removed.iterator());
            try {
                this.stateMgr.edit();
            }
            catch (IllegalStateException e) {
                String msg = "Unable to start edit operation";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            boolean succeeded = false;
            try {
                this.removeTransientItems(removed.iterator());
                this.processShareableNodes(dirty.iterator());
                if (this.initVersionHistories(dirty.iterator())) {
                    dirty = this.getTransientStates();
                }
                this.persistTransientItems(dirty.iterator());
                it = dirty.iterator();
                while (it.hasNext()) {
                    transientState = (ItemState)it.next();
                    this.stateMgr.disposeTransientItemState(transientState);
                }
                this.stateMgr.update();
                succeeded = true;
            }
            catch (StaleItemStateException e) {
                throw new InvalidItemStateException(e.getMessage());
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to update item: " + this, (Throwable)e);
            }
            finally {
                if (!succeeded) {
                    this.stateMgr.cancel();
                    this.restoreTransientItems(dirty.iterator());
                }
            }
            it = removed.iterator();
            while (it.hasNext()) {
                transientState = (ItemState)it.next();
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    public synchronized void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        Iterator iter;
        ItemState transientState;
        this.sanityCheck();
        if (keepChanges) {
            return;
        }
        if (this.isNode() && this.getDepth() == 0) {
            this.stateMgr.disposeAllTransientItemStates();
            return;
        }
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        if (this.isTransient()) {
            transientState = this.getItemState();
            switch (transientState.getStatus()) {
                case 5: 
                case 6: {
                    list.add(transientState);
                    break;
                }
                case 2: {
                    if (!transientState.getParentId().equals(transientState.getOverlayedState().getParentId())) {
                        throw new RepositoryException("Cannot refresh a moved item: " + this + " - possible solution: refresh the parent");
                    }
                    list.add(transientState);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot refresh a new item: " + this);
                }
                default: {
                    log.warn("Unexpected item state status:" + transientState.getStatus() + " of " + this);
                }
            }
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block8: while (iter.hasNext()) {
                transientState = (ItemState)iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        list.add(transientState);
                        continue block8;
                    }
                }
                log.debug("unexpected state status (" + transientState.getStatus() + ")");
            }
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            transientState = (ItemState)iter.next();
            this.stateMgr.disposeTransientItemState(transientState);
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                transientState = (ItemState)iter.next();
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    public Item getAncestor(int degree) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        if (degree == 0) {
            return this.itemMgr.getRootNode();
        }
        try {
            Path path = this.getPrimaryPath();
            int relDegree = path.getAncestorCount() - degree;
            if (relDegree < 0) {
                throw new ItemNotFoundException();
            }
            if (relDegree == 0) {
                return this;
            }
            Path ancestorPath = path.getAncestor(relDegree);
            return this.itemMgr.getNode(ancestorPath);
        }
        catch (PathNotFoundException pnfe) {
            throw new ItemNotFoundException();
        }
    }

    public String getPath() throws RepositoryException {
        this.sanityCheck();
        return this.session.getJCRPath(this.getPrimaryPath());
    }

    public int getDepth() throws RepositoryException {
        this.sanityCheck();
        ItemState state = this.getItemState();
        if (state.getParentId() == null) {
            return 0;
        }
        return this.session.getHierarchyManager().getDepth(this.id);
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.sanityCheck();
        if (this == otherItem) {
            return true;
        }
        if (otherItem instanceof ItemImpl) {
            ItemImpl other = (ItemImpl)otherItem;
            return this.id.equals(other.id) && this.session.getWorkspace().getName().equals(other.getSession().getWorkspace().getName());
        }
        return false;
    }

    public String toString() {
        return this.safeGetJCRPath();
    }
}

