/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.lock.AbstractLockInfo;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XAEnvironment;
import org.apache.jackrabbit.core.lock.XALock;
import org.apache.jackrabbit.spi.Path;

public class XALockManager
implements LockManager,
InternalXAResource {
    private static final String XA_ENV_ATTRIBUTE_NAME = "XALockManager.XAEnv";
    private final LockManagerImpl lockMgr;
    private XAEnvironment xaEnv;

    public XALockManager(LockManagerImpl lockMgr) {
        this.lockMgr = lockMgr;
    }

    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        return this.lock(node, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timoutHint, String ownerInfo) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.lock(node, isDeep, isSessionScoped, timoutHint, ownerInfo) : this.lockMgr.internalLock(node, isDeep, isSessionScoped, timoutHint, ownerInfo);
        this.lockMgr.writeLockProperties(node, info.lockOwner, info.deep);
        return new XALock(this, info, (Node)node);
    }

    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        if (info == null) {
            throw new LockException("Node not locked: " + node);
        }
        SessionImpl session = (SessionImpl)node.getSession();
        NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
        return new XALock(this, info, (Node)holder);
    }

    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        AbstractLockInfo[] infos = this.isInXA() ? this.xaEnv.getLockInfos(session) : this.lockMgr.getLockInfos(session);
        XALock[] locks = new XALock[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            AbstractLockInfo info = infos[i];
            NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
            locks[i] = new XALock(this, info, (Node)holder);
        }
        return locks;
    }

    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        this.lockMgr.removeLockProperties(node);
        if (this.isInXA()) {
            this.xaEnv.unlock(node);
        } else {
            this.lockMgr.internalUnlock(node);
        }
    }

    public boolean holdsLock(NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null && info.getId().equals(node.getId());
    }

    public boolean isLockHolder(Session session, NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null && info.getId().equals(node.getId()) && info.getLockHolder() == session;
    }

    public boolean isLocked(NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null;
    }

    public void checkLock(NodeImpl node) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        if (info != null && info.getLockHolder() != node.getSession()) {
            throw new LockException("Node locked.");
        }
    }

    public void checkLock(Path path, Session session) throws LockException, RepositoryException {
        SessionImpl sessionImpl = (SessionImpl)session;
        this.checkLock(sessionImpl.getItemManager().getNode(path));
    }

    public void lockTokenAdded(SessionImpl session, String lt) throws RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.addLockToken(session, lt);
        } else {
            this.lockMgr.lockTokenAdded(session, lt);
        }
    }

    public void lockTokenRemoved(SessionImpl session, String lt) throws RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.removeLockToken(session, lt);
        } else {
            this.lockMgr.lockTokenRemoved(session, lt);
        }
    }

    public void associate(TransactionContext tx) {
        XAEnvironment xaEnv = null;
        if (tx != null && (xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME)) == null) {
            xaEnv = new XAEnvironment(this.lockMgr);
            tx.setAttribute(XA_ENV_ATTRIBUTE_NAME, xaEnv);
        }
        this.xaEnv = xaEnv;
    }

    public void beforeOperation(TransactionContext tx) {
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.prepare();
        }
    }

    public void commit(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.commit();
        }
    }

    public void rollback(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.rollback();
        }
    }

    public void afterOperation(TransactionContext tx) {
    }

    public boolean differentXAEnv(AbstractLockInfo info) {
        if (this.isInXA()) {
            return this.xaEnv.differentXAEnv(info);
        }
        return info instanceof XAEnvironment.LockInfo;
    }

    private boolean isInXA() {
        return this.xaEnv != null;
    }
}

