/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TraversingNodeResolver
extends NodeResolver {
    private static final Logger log = LoggerFactory.getLogger((Class)TraversingNodeResolver.class);

    TraversingNodeResolver(Session session, NamePathResolver resolver) {
        super(session, resolver);
    }

    public Node findNode(Name nodeName, Name ntName) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        SessionImpl sImpl = (SessionImpl)this.getSession();
        if (sImpl.nodeExists(sr)) {
            try {
                Node root = sImpl.getNode(sr);
                return this.collectNode(nodeName, ntName, root.getNodes());
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return null;
    }

    public Node findNode(Name propertyName, String value, Name ntName) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        SessionImpl sImpl = (SessionImpl)this.getSession();
        if (sImpl.nodeExists(sr)) {
            try {
                Node root = sImpl.getNode(sr);
                NodeIterator nodes = this.collectNodes(value, Collections.singleton(propertyName), ntName, root.getNodes(), true, 1L);
                if (nodes.hasNext()) {
                    return nodes.nextNode();
                }
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return null;
    }

    public NodeIterator findNodes(Set propertyNames, String value, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        SessionImpl sImpl = (SessionImpl)this.getSession();
        if (sImpl.nodeExists(sr)) {
            try {
                Node root = sImpl.getNode(sr);
                return this.collectNodes(value, propertyNames, ntName, root.getNodes(), exact, maxSize);
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return NodeIteratorAdapter.EMPTY;
    }

    private Node collectNode(Name nodeName, Name ntName, NodeIterator nodes) {
        NodeImpl match = null;
        while (match == null && nodes.hasNext()) {
            NodeImpl node = (NodeImpl)nodes.nextNode();
            try {
                if (node.isNodeType(ntName) && nodeName.equals(node.getQName())) {
                    match = node;
                    continue;
                }
                if (!node.hasNodes()) continue;
                match = this.collectNode(nodeName, ntName, node.getNodes());
            }
            catch (RepositoryException e) {
                log.warn("Internal error while accessing node", (Throwable)e);
            }
        }
        return match;
    }

    private NodeIterator collectNodes(String value, Set props, Name ntName, NodeIterator nodes, boolean exact, long maxSize) {
        HashSet matchSet = new HashSet();
        this.collectNodes(value, props, ntName, nodes, matchSet, exact, maxSize);
        return new NodeIteratorAdapter(matchSet);
    }

    private void collectNodes(String value, Set propertyNames, Name nodeTypeName, NodeIterator itr, Set matchSet, boolean exact, long maxSize) {
        while (itr.hasNext()) {
            NodeImpl node = (NodeImpl)itr.nextNode();
            try {
                if (TraversingNodeResolver.matches(node, nodeTypeName, propertyNames, value, exact)) {
                    matchSet.add(node);
                    --maxSize;
                }
                if (!node.hasNodes() || maxSize <= 0L) continue;
                this.collectNodes(value, propertyNames, nodeTypeName, node.getNodes(), matchSet, exact, maxSize);
            }
            catch (RepositoryException e) {
                log.warn("Internal error while accessing node", (Throwable)e);
            }
        }
    }

    private static boolean matches(NodeImpl node, Name nodeTypeName, Collection propertyNames, String value, boolean exact) throws RepositoryException {
        boolean match;
        block9: {
            match = false;
            if (node.isNodeType(nodeTypeName)) {
                if (value == null) {
                    match = true;
                } else {
                    try {
                        if (propertyNames.isEmpty()) {
                            match = exact ? node.getName().equals(value) : node.getName().matches(".*" + value + ".*");
                            break block9;
                        }
                        Iterator pItr = propertyNames.iterator();
                        while (!match && pItr.hasNext()) {
                            Name propertyName = (Name)pItr.next();
                            if (!node.hasProperty(propertyName)) continue;
                            PropertyImpl prop = node.getProperty(propertyName);
                            if (prop.isMultiple()) {
                                Value[] values = prop.getValues();
                                for (int i = 0; i < values.length && !match; ++i) {
                                    match = TraversingNodeResolver.matches(value, values[i].getString(), exact);
                                }
                                continue;
                            }
                            match = TraversingNodeResolver.matches(value, prop.getString(), exact);
                        }
                    }
                    catch (PatternSyntaxException pe) {
                        log.debug("couldn't search for {}, pattern invalid: {}", (Object)value, (Object)pe.getMessage());
                    }
                }
            }
        }
        return match;
    }

    private static boolean matches(String value, String toMatch, boolean exact) {
        return exact ? toMatch.equals(value) : toMatch.matches(".*" + value + ".*");
    }
}

