/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnectionFactory;

public final class JCARepositoryHandle
implements Repository,
Referenceable,
Serializable {
    private final JCAManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private Reference reference;

    public JCARepositoryHandle(JCAManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials creds) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(creds, null);
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspace);
    }

    public Session login(Credentials creds, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(new JCAConnectionRequestInfo(creds, workspace));
    }

    private Session login(JCAConnectionRequestInfo cri) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            return (Session)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
        }
        catch (ResourceException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e.getLinkedException();
            }
            if (cause instanceof LoginException) {
                throw (LoginException)cause;
            }
            if (cause instanceof NoSuchWorkspaceException) {
                throw (NoSuchWorkspaceException)cause;
            }
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            if (cause != null) {
                throw new RepositoryException(cause);
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public String[] getDescriptorKeys() {
        return this.mcf.getRepository().getDescriptorKeys();
    }

    public String getDescriptor(String key) {
        return this.mcf.getRepository().getDescriptor(key);
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }
}

