/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JcrDavException
extends DavException {
    private static Logger log = LoggerFactory.getLogger((Class)JcrDavException.class);
    private static Map codeMap = new LinkedHashMap(20);
    private Class exceptionClass;

    private static int lookupErrorCode(Class exceptionClass) {
        Integer code = (Integer)codeMap.get(exceptionClass);
        if (code == null) {
            Iterator it = codeMap.keySet().iterator();
            while (it.hasNext()) {
                Class jcrExceptionClass = (Class)it.next();
                if (!jcrExceptionClass.isAssignableFrom(exceptionClass)) continue;
                code = (Integer)codeMap.get(jcrExceptionClass);
                break;
            }
            if (code == null) {
                code = new Integer(403);
            }
        }
        return code;
    }

    public JcrDavException(Throwable cause, int errorCode) {
        super(errorCode, cause.getMessage(), cause, null);
        this.exceptionClass = cause.getClass();
        if (log.isDebugEnabled()) {
            log.debug("Handling exception with error code " + errorCode, cause);
        }
    }

    public JcrDavException(RepositoryException cause) {
        this(cause, JcrDavException.lookupErrorCode(((Object)((Object)cause)).getClass()));
    }

    public boolean hasErrorCondition() {
        return true;
    }

    public Element toXml(Document document) {
        Element error = DomUtil.createElement((Document)document, (String)"error", (Namespace)DavConstants.NAMESPACE);
        Element excep = DomUtil.createElement((Document)document, (String)"exception", (Namespace)ItemResourceConstants.NAMESPACE);
        DomUtil.addChildElement((Element)excep, (String)"class", (Namespace)ItemResourceConstants.NAMESPACE, (String)this.exceptionClass.getName());
        DomUtil.addChildElement((Element)excep, (String)"message", (Namespace)ItemResourceConstants.NAMESPACE, (String)this.getMessage());
        error.appendChild(excep);
        return error;
    }

    static {
        codeMap.put(AccessDeniedException.class, new Integer(403));
        codeMap.put(ConstraintViolationException.class, new Integer(409));
        codeMap.put(InvalidItemStateException.class, new Integer(409));
        codeMap.put(InvalidSerializedDataException.class, new Integer(400));
        codeMap.put(InvalidQueryException.class, new Integer(400));
        codeMap.put(ItemExistsException.class, new Integer(409));
        codeMap.put(ItemNotFoundException.class, new Integer(403));
        codeMap.put(LockException.class, new Integer(423));
        codeMap.put(MergeException.class, new Integer(409));
        codeMap.put(NamespaceException.class, new Integer(409));
        codeMap.put(NoSuchNodeTypeException.class, new Integer(409));
        codeMap.put(NoSuchWorkspaceException.class, new Integer(409));
        codeMap.put(PathNotFoundException.class, new Integer(409));
        codeMap.put(ReferentialIntegrityException.class, new Integer(409));
        codeMap.put(LoginException.class, new Integer(401));
        codeMap.put(UnsupportedRepositoryOperationException.class, new Integer(501));
        codeMap.put(ValueFormatException.class, new Integer(409));
        codeMap.put(VersionException.class, new Integer(409));
        codeMap.put(RepositoryException.class, new Integer(403));
    }
}

