/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NamespaceRemappingTest
extends AbstractJCRTest {
    private Session session;
    private NamespaceRegistry nsr;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.nsr = this.session.getWorkspace().getNamespaceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
            Object var2_1 = null;
            this.nsr = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.nsr = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    public void testNamespaceRemapping() throws RepositoryException {
        Property primaryTypeProp = this.session.getRootNode().getProperty(this.jcrPrimaryType);
        NodeType ntBaseType = this.session.getWorkspace().getNodeTypeManager().getNodeType(this.ntBase);
        String jcrPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(jcrPrefix, "http://www.jcp.org/jcr/1.0");
        String ntPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(ntPrefix, "http://www.jcp.org/jcr/nt/1.0");
        NamespaceRemappingTest.assertTrue((String)"Unable to retrieve property with new namespace prefix.", (boolean)this.session.getRootNode().getProperty(jcrPrefix + ":primaryType").isSame((Item)primaryTypeProp));
        NamespaceRemappingTest.assertEquals((String)"NodeType name does not use new namespace prefix.", (String)ntBaseType.getName(), (String)(ntPrefix + ":base"));
        String propval = this.session.getRootNode().getProperty(jcrPrefix + ":primaryType").getString();
        String primaryType = this.session.getRootNode().getPrimaryNodeType().getName();
        NamespaceRemappingTest.assertEquals((String)"Remapping of jcr prefix failed", (String)primaryType, (String)propval);
    }

    public void testRemapClearing() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        this.session.logout();
        this.session = helper.getReadOnlySession();
        try {
            this.session.getNamespaceURI(testPrefix);
            NamespaceRemappingTest.fail((String)"Must throw a NamespaceException on unknown prefix.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testXmlRemapping() throws RepositoryException {
        try {
            this.session.setNamespacePrefix("xml", "http://www.jcp.org/jcr/1.0");
            NamespaceRemappingTest.fail((String)"Remapping a namespace uri to 'xml' must not be possible");
        }
        catch (NamespaceException nse) {
            // empty catch block
        }
        try {
            this.session.setNamespacePrefix("xmlfoo", "http://www.jcp.org/jcr/1.0");
            NamespaceRemappingTest.fail((String)"Remapping a namespace uri to 'xmlfoo' must not be possible");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testNamespaceException() throws RepositoryException {
        String testURI = this.getUnusedURI();
        String prefix = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        try {
            this.session.setNamespacePrefix(prefix, testURI);
            NamespaceRemappingTest.fail((String)"NamespaceRegistry must not register a URI with an already assign prefix");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testGetNamespaceURI() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String uri = this.session.getNamespaceURI(testPrefix);
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespaceURI does not return the correct value.", (String)"http://www.jcp.org/jcr/1.0", (String)uri);
    }

    public void testGetNamespacePrefix() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String prefix = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespacePrefix does not return the correct value.", (String)testPrefix, (String)prefix);
    }

    public void testGetNamespacePrefixes() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String[] prefixes = this.session.getNamespacePrefixes();
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespacePrefixes() must return all prefixes currently set for this session.", (int)this.nsr.getPrefixes().length, (int)this.session.getNamespacePrefixes().length);
        String prefixNSR = this.nsr.getPrefix("http://www.jcp.org/jcr/1.0");
        for (int i = 0; i < prefixes.length; ++i) {
            if (!prefixes[i].equals(prefixNSR)) continue;
            NamespaceRemappingTest.fail((String)"Session.getNamespacePrefixes() must not return the prefixes over-ridden by Session.setNamespacePrefix");
        }
    }

    private String getUnusedPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.addAll(Arrays.asList(this.session.getNamespacePrefixes()));
        String prefix = "myapp";
        int count = 0;
        while (prefixes.contains(prefix + count)) {
            ++count;
        }
        return prefix + count;
    }

    private String getUnusedURI() throws RepositoryException {
        HashSet<String> uris = new HashSet<String>();
        uris.addAll(Arrays.asList(this.nsr.getURIs()));
        String uri = "http://www.unknown-company.com/namespace";
        int count = 0;
        while (uris.contains(uri + count)) {
            ++count;
        }
        return uri + count;
    }
}

