/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.NodeMixinUtil;

public class NodeAddMixinTest
extends AbstractJCRTest {
    public void testAddSuccessfully() throws NotExecutableException, RepositoryException {
        Node node;
        Session session = this.testRootNode.getSession();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node = this.testRootNode.addNode(this.nodeName1, this.testNodeType));
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.addMixin(mixinName);
        Value[] mixinValues = node.getProperty(this.jcrMixinTypes).getValues();
        boolean found = false;
        for (int i = 0; i < mixinValues.length; ++i) {
            found |= mixinName.equals(mixinValues[i].getString());
        }
        if (!found) {
            NodeAddMixinTest.fail((String)("Mixin type must be added to property " + this.jcrMixinTypes + " immediately."));
        }
        this.testRootNode.save();
        NodeType[] mixins = node.getMixinNodeTypes();
        found = false;
        for (int i = 0; i < mixins.length; ++i) {
            found |= mixinName.equals(mixins[i].getName());
        }
        if (!found) {
            NodeAddMixinTest.fail((String)("Mixin '" + mixinName + "' type not added."));
        }
    }

    public void testAddNonExisting() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        String nonExistingMixinName = NodeMixinUtil.getNonExistingMixinName(session);
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            node.addMixin(nonExistingMixinName);
            NodeAddMixinTest.fail((String)"Node.addMixin(String mixinName) must throw a NoSuchNodeTypeException if mixinName is an unknown mixin type");
        }
        catch (NoSuchNodeTypeException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocked() throws NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!node.isNodeType(this.mixLockable)) {
            if (node.canAddMixin(this.mixLockable)) {
                node.addMixin(this.mixLockable);
            } else {
                throw new NotExecutableException("Node " + this.nodeName1 + " is not lockable and does not " + "allow to add mix:lockable");
            }
        }
        this.testRootNode.save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = helper.getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            try {
                node.addMixin(mixinName);
                node.save();
                NodeAddMixinTest.fail((String)"Node.addMixin(String mixinName) must throw a LockException if the node is locked.");
            }
            catch (LockException e) {
                // empty catch block
            }
            node2.unlock();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            session2.logout();
            throw throwable;
        }
        session2.logout();
    }

    public void testCheckedIn() throws NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!node.isNodeType(this.mixVersionable)) {
            if (node.canAddMixin(this.mixVersionable)) {
                node.addMixin(this.mixVersionable);
            } else {
                throw new NotExecutableException("Node " + this.nodeName1 + " is not versionable and does not " + "allow to add mix:versionable");
            }
        }
        this.testRootNode.save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.checkin();
        try {
            node.addMixin(mixinName);
            NodeAddMixinTest.fail((String)"Node.addMixin(String mixinName) must throw a VersionException if the node is checked-in.");
        }
        catch (VersionException e) {
            // empty catch block
        }
    }

    public void testAddMixinReferencable() throws NotExecutableException, RepositoryException {
        this.checkMixReferenceable();
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (this.needsMixin(node, this.mixReferenceable)) {
            node.addMixin(this.mixReferenceable);
        }
        this.testRootNode.save();
        NodeAddMixinTest.assertTrue((boolean)node.isNodeType(this.mixReferenceable));
        try {
            String uuid = node.getProperty(this.jcrUUID).getValue().getString();
            NodeAddMixinTest.assertNotNull((String)"Acessing jcr:uuid after assginment of mix:referencable returned null", (Object)uuid);
            NodeAddMixinTest.assertTrue((String)"Acessing jcr:uuid after assginment of mix:referencable returned an empty String!", (uuid.length() > 0 ? 1 : 0) != 0);
        }
        catch (ValueFormatException e) {
            NodeAddMixinTest.fail((String)"Acessing jcr:uuid after assginment of mix:referencable caused an ValueFormatException!");
        }
    }

    private void checkMixReferenceable() throws RepositoryException, NotExecutableException {
        try {
            this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.mixReferenceable);
        }
        catch (NoSuchNodeTypeException e) {
            throw new NotExecutableException("Repository does not support mix:referenceable");
        }
    }
}

