/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class ReferenceableRootNodesTest
extends AbstractJCRTest {
    protected Session sessionW2;
    protected Session session;

    protected void setUp() throws Exception {
        boolean sameWsp;
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.sessionW2 = helper.getReadOnlySession(this.workspaceName);
        String wspName = this.session.getWorkspace().getName();
        boolean bl = wspName == null ? this.workspaceName == null : (sameWsp = wspName.equals(this.workspaceName));
        if (sameWsp) {
            throw new NotExecutableException("Cannot compare uuid behaviour of different workspaces. Only a single workspace configured.");
        }
    }

    protected void tearDown() throws Exception {
        if (this.sessionW2 != null) {
            this.sessionW2.logout();
            this.sessionW2 = null;
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testReferenceableRootNode() throws RepositoryException, NotExecutableException {
        Node rootNodeW2;
        Node rootNode = this.session.getRootNode();
        if (rootNode.isNodeType(this.mixReferenceable)) {
            rootNodeW2 = this.sessionW2.getRootNode();
            if (!rootNodeW2.isNodeType(this.mixReferenceable)) {
                ReferenceableRootNodesTest.fail((String)"Root node in second workspace is not referenceable.");
            }
        } else {
            throw new NotExecutableException("Root node is not referenceable");
        }
        ReferenceableRootNodesTest.assertEquals((String)"Referenceable root nodes of different workspaces must have same UUID.", (String)rootNode.getUUID(), (String)rootNodeW2.getUUID());
    }
}

