/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class RepositoryDescriptorTest
extends AbstractJCRTest {
    private static final Set requiredDescriptorKeys = new HashSet();
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testRequiredDescriptors() {
        Iterator it = requiredDescriptorKeys.iterator();
        while (it.hasNext()) {
            String descriptor = this.session.getRepository().getDescriptor((String)it.next());
            RepositoryDescriptorTest.assertNotNull((String)"Not all required descriptors are available.", (Object)descriptor);
        }
    }

    public void testGetDescriptorKeys() {
        List<String> keys = Arrays.asList(this.session.getRepository().getDescriptorKeys());
        Iterator it = requiredDescriptorKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            RepositoryDescriptorTest.assertTrue((String)(key + " is missing from the required descriptor keys."), (boolean)keys.contains(key));
        }
    }

    static {
        requiredDescriptorKeys.add("level.1.supported");
        requiredDescriptorKeys.add("level.2.supported");
        requiredDescriptorKeys.add("option.locking.supported");
        requiredDescriptorKeys.add("option.observation.supported");
        requiredDescriptorKeys.add("option.query.sql.supported");
        requiredDescriptorKeys.add("option.transactions.supported");
        requiredDescriptorKeys.add("option.versioning.supported");
        requiredDescriptorKeys.add("query.xpath.doc.order");
        requiredDescriptorKeys.add("query.xpath.pos.index");
        requiredDescriptorKeys.add("jcr.repository.name");
        requiredDescriptorKeys.add("jcr.repository.vendor");
        requiredDescriptorKeys.add("jcr.repository.vendor.url");
        requiredDescriptorKeys.add("jcr.repository.version");
        requiredDescriptorKeys.add("jcr.specification.name");
        requiredDescriptorKeys.add("jcr.specification.version");
    }
}

