/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SessionReadMethodsTest
extends AbstractJCRTest {
    private final String RANDOM_UUID = "710def90-80cd-11d9-9669-0800200c9a66";
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testGetItemFailure() throws RepositoryException, NotExecutableException {
        try {
            this.session.getItem(this.getNonExistingPath());
            SessionReadMethodsTest.fail((String)"Session.getItem() does not throw PathNotFoundException in case a invalid path is provided.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGetItem() throws RepositoryException {
        Item item = this.session.getItem(this.testRoot);
        SessionReadMethodsTest.assertTrue((String)"Session.getItem doesn't return the correct item.", (boolean)item.isSame((Item)this.testRootNode));
    }

    public void testItemExists() throws RepositoryException {
        SessionReadMethodsTest.assertTrue((String)"Session.itemExists() returns false on the testRootNode.", (boolean)this.session.itemExists(this.testRootNode.getPath()));
        SessionReadMethodsTest.assertFalse((String)"Session.itemExists() returns true on a malformed path.", (boolean)this.session.itemExists(this.getNonExistingPath()));
    }

    public void testGetNodeByUUIDFailure() throws RepositoryException {
        try {
            this.session.getNodeByUUID("710def90-80cd-11d9-9669-0800200c9a66");
            SessionReadMethodsTest.fail((String)"Not valid UUID should throw a ItemNotFoundException.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetNodeByUUID() throws RepositoryException, NotExecutableException {
        Node referenced = this.findReferenceable(this.testRootNode);
        if (referenced == null) {
            throw new NotExecutableException("Workspace does not contain a referenceable node.");
        }
        String uuid = referenced.getProperty(this.jcrUUID).getString();
        Node node = this.session.getNodeByUUID(uuid);
        SessionReadMethodsTest.assertTrue((String)"Node retrieved with session.getNodeByUUID is not the same as the node having the given uuid.", (boolean)referenced.isSame((Item)node));
    }

    public void testGetAttribute() throws NotExecutableException {
        String[] names = this.session.getAttributeNames();
        if (names.length == 0) {
            throw new NotExecutableException("No attributes set in this session.");
        }
        for (int i = 0; i < names.length; ++i) {
            SessionReadMethodsTest.assertNotNull((String)"getAttribute(String name) returned null although the requested attribute is existing.", (Object)this.session.getAttribute(names[i]));
        }
    }

    public void testGetAttributeFailure() {
        String[] names = this.session.getAttributeNames();
        StringBuffer notExistingName = new StringBuffer("X");
        for (int i = 0; i < names.length; ++i) {
            notExistingName.append(names[i]);
        }
        SessionReadMethodsTest.assertNull((String)"getAttribute(String name) must return null if the requested attribute is not existing", (Object)this.session.getAttribute(notExistingName.toString()));
    }

    public void testGetAttributeNames() {
        String[] names = this.session.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            SessionReadMethodsTest.assertNotNull((String)"An attribute name returned by getAttributeNames() does not exist.", (Object)this.session.getAttribute(names[i]));
        }
    }

    public void testIsLive() {
        SessionReadMethodsTest.assertTrue((String)"Method isLive() must return true if the session is usable by the client.", (boolean)this.session.isLive());
        this.session.logout();
        SessionReadMethodsTest.assertFalse((String)"Method isLive() must return false if the session is not usable by the client, e.g. if the session is logged-out.", (boolean)this.session.isLive());
    }

    private String getNonExistingPath() throws RepositoryException {
        StringBuffer tmp = new StringBuffer();
        if (this.testRootNode.getName().length() > 0) {
            tmp.append("/").append(this.testRootNode.getName());
        }
        int count = 0;
        String nodeName = "node";
        while (this.testRootNode.hasNode(nodeName + count)) {
            ++count;
        }
        tmp.append("/").append(nodeName + count);
        return tmp.toString();
    }

    private Node findReferenceable(Node node) throws RepositoryException {
        Node referenced = null;
        if (node.isNodeType(this.mixReferenceable)) {
            return node;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            referenced = this.findReferenceable(n);
            if (referenced == null) continue;
            return referenced;
        }
        return referenced;
    }
}

