/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class SetValueConstraintViolationExceptionTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinaryProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 2, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        Value valueNotSatisfied1 = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        Value valueNotSatisfied2 = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied1 == null || valueNotSatisfied2 == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), valueSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        InputStream in = valueNotSatisfied1.getStream();
        try {
            prop.setValue(in);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(InputStream value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        try {
            prop.setValue(valueNotSatisfied2);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testBooleanProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 6, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No boolean property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No boolean property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), valueSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(valueNotSatisfied.getBoolean());
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(boolean value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            prop.setValue(valueNotSatisfied);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testDateProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 5, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), valueSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(valueNotSatisfied.getDate());
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Date value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            prop.setValue(valueNotSatisfied);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testDoubleProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 4, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), valueSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(valueNotSatisfied.getDouble());
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(double value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            prop.setValue(valueNotSatisfied);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testLongProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 3, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), valueSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(valueNotSatisfied.getLong());
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(long value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            prop.setValue(valueNotSatisfied);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testReferenceProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node nodeNotSatisfied;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 9, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No reference property def with testable value constraints has been found");
        }
        String[] constraints = propDef.getValueConstraints();
        String nodeTypeSatisfied = constraints[0];
        String nodeTypeNotSatisfied = null;
        NodeTypeManager manager = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            String name = type.getName();
            int i = 0;
            if (i >= constraints.length || name.equals(constraints[i])) continue;
            nodeTypeNotSatisfied = name;
            break;
        }
        if (nodeTypeNotSatisfied == null) {
            throw new NotExecutableException("No reference property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            Node nodeSatisfied = this.testRootNode.addNode(this.nodeName3, nodeTypeSatisfied);
            nodeSatisfied.addMixin(this.mixReferenceable);
            nodeNotSatisfied = this.testRootNode.addNode(this.nodeName4, nodeTypeNotSatisfied);
            nodeNotSatisfied.addMixin(this.mixReferenceable);
            this.testRootNode.save();
            prop = node.setProperty(propDef.getName(), nodeSatisfied);
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(nodeNotSatisfied);
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Node value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            prop.setValue(this.superuser.getValueFactory().createValue(nodeNotSatisfied));
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleBinaryProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 2, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple binary property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No multiple binary property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value[] values) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleBooleanProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 6, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple boolean property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No multiple boolean property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value[] values) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleDateProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 5, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple date property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No multiple date property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value[] values) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleDoubleProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 4, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple double property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No multiple double property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value[] values) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleLongProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 3, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple long property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No multiple long property def with testable value constraints has been found");
        }
        Value valueSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, true);
        if (valueSatisfied == null) {
            throw new NotExecutableException("The value constraints do not allow any value.");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testMultipleReferenceProperty() throws NotExecutableException, RepositoryException {
        Property prop;
        Node nodeNotSatisfied;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 9, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple reference property def with testable value constraints has been found");
        }
        String[] constraints = propDef.getValueConstraints();
        String nodeTypeSatisfied = constraints[0];
        String nodeTypeNotSatisfied = null;
        NodeTypeManager manager = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            String name = type.getName();
            int i = 0;
            if (i >= constraints.length || name.equals(constraints[i])) continue;
            nodeTypeNotSatisfied = name;
            break;
        }
        if (nodeTypeNotSatisfied == null) {
            throw new NotExecutableException("No multiple reference property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            Node nodeSatisfied = this.testRootNode.addNode(this.nodeName3, nodeTypeSatisfied);
            nodeSatisfied.addMixin(this.mixReferenceable);
            nodeNotSatisfied = this.testRootNode.addNode(this.nodeName4, nodeTypeNotSatisfied);
            nodeNotSatisfied.addMixin(this.mixReferenceable);
            this.testRootNode.save();
            Value valueSatisfied = this.superuser.getValueFactory().createValue(nodeSatisfied);
            prop = node.setProperty(propDef.getName(), new Value[]{valueSatisfied});
            this.testRootNode.save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            Value valueNotSatisfied = this.superuser.getValueFactory().createValue(nodeNotSatisfied);
            prop.setValue(new Value[]{valueNotSatisfied});
            node.save();
            SetValueConstraintViolationExceptionTest.fail((String)"setValue(Value[] values) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }
}

