/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyBetweenTest;

public class WorkspaceCloneTest
extends AbstractWorkspaceCopyBetweenTest {
    public void testCloneNodes() throws RepositoryException {
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        WorkspaceCloneTest.assertFalse((boolean)this.superuserW2.hasPendingChanges());
    }

    public void testCloneNodesTwice() throws RepositoryException {
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        Node folder = this.node1.addNode(this.nodeName3);
        folder.addMixin(this.mixReferenceable);
        this.node1.save();
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        WorkspaceCloneTest.assertFalse((boolean)this.superuserW2.hasPendingChanges());
    }

    public void testCloneNodesInvalidWorkspace() throws RepositoryException {
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        try {
            this.workspaceW2.clone(this.getNonExistingWorkspaceName(this.superuser), this.node1.getPath(), dstAbsPath, true);
            WorkspaceCloneTest.fail((String)"Invalid Source Workspace should throw NoSuchWorkspaceException.");
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testCloneNodesAbsolutePath() {
        try {
            String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName() + "[2]";
            this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
            WorkspaceCloneTest.fail((String)"Cloning a node to an absolute path containing index should not be possible.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testCloneNodesConstraintViolationException() throws RepositoryException {
        Node subNodesNotAllowedNode = this.testRootNodeW2.addNode(this.nodeName3, this.ntBase);
        this.testRootNodeW2.save();
        try {
            String dstAbsPath = subNodesNotAllowedNode.getPath() + "/" + this.node2.getName();
            this.workspaceW2.clone(this.workspace.getName(), this.node2.getPath(), dstAbsPath, true);
            WorkspaceCloneTest.fail((String)"Cloning a node below a node which can not have any sub nodes should throw a ConstraintViolationException.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloneNodesAccessDenied() throws RepositoryException {
        Session readOnlySuperuser = helper.getReadOnlySession();
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
            try {
                readOnlySuperuser.getWorkspace().clone(this.workspaceW2.getName(), this.node1.getPath(), dstAbsPath, true);
                WorkspaceCloneTest.fail((String)"Cloning in a read-only session should throw an AccessDeniedException.");
            }
            catch (AccessDeniedException accessDeniedException) {
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            readOnlySuperuser.logout();
            throw throwable;
        }
        readOnlySuperuser.logout();
    }

    public void testCloneNodesPathNotExisting() throws RepositoryException {
        String srcAbsPath = this.node1.getPath();
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        String invalidSrcPath = srcAbsPath + "invalid";
        try {
            this.workspaceW2.clone(this.workspace.getName(), invalidSrcPath, dstAbsPath, true);
            WorkspaceCloneTest.fail((String)("Not existing source path '" + invalidSrcPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        String invalidDstParentPath = this.node2W2.getPath() + "invalid/" + this.node1.getName();
        try {
            this.workspaceW2.clone(this.workspace.getName(), srcAbsPath, invalidDstParentPath, true);
            WorkspaceCloneTest.fail((String)("Not existing destination parent path '" + invalidDstParentPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCloneNodesLocked() throws RepositoryException {
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        Node lockTarget = (Node)this.rwSessionW2.getItem(this.node2W2.getPath());
        if (!lockTarget.getPrimaryNodeType().isNodeType(this.mixLockable)) {
            lockTarget.addMixin(this.mixLockable);
            lockTarget.getParent().save();
        }
        lockTarget.lock(true, true);
        try {
            try {
                this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
                WorkspaceCloneTest.fail((String)"LockException was expected.");
            }
            catch (LockException lockException) {
                Object var5_4 = null;
                lockTarget.unlock();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lockTarget.unlock();
            throw throwable;
        }
        lockTarget.unlock();
    }
}

