/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanAddChildNodeCallWithNodeTypeTest
extends AbstractJCRTest {
    private Session session;
    private NodeTypeManager manager;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testDefinedAndLegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No child node def with defaultPrimaryType found");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        String nodeTypeName = nodeDef.getRequiredPrimaryTypes()[0].getName();
        CanAddChildNodeCallWithNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return true if childNodeName and nodeTypeName match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(childNodeName, nodeTypeName));
    }

    public void testDefinedAndIllegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        String legalType = nodeDef.getRequiredPrimaryTypes()[0].getName();
        String illegalType = NodeTypeUtil.getIllegalChildNodeType(this.manager, legalType);
        if (illegalType == null) {
            throw new NotExecutableException("No illegal node type name found");
        }
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if childNodeName does and nodeTypeName does not match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(childNodeName, illegalType));
    }

    public void testUndefined() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        String type = nodeDef.getRequiredPrimaryTypes()[0].getName();
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if childNodeName does not match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(undefinedName, type));
    }

    public void testResidualAndLegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable residual child node def.");
        }
        String type = nodeDef.getRequiredPrimaryTypes()[0].getName();
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return true for a not defined childNodeName if nodeTypeName matches the type of a residual child node def", (boolean)nodeType.canAddChildNode(undefinedName, type));
    }

    public void testResidualAndIllegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable residual child node def.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        String legalType = nodeDef.getRequiredPrimaryTypes()[0].getName();
        String illegalType = NodeTypeUtil.getIllegalChildNodeType(this.manager, legalType);
        if (illegalType == null) {
            throw new NotExecutableException("No illegal node type name found");
        }
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false for a not defined childNodeName if nodeTypeName does not matches the type of a residual child node def", (boolean)nodeType.canAddChildNode(undefinedName, illegalType));
    }
}

