/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanRemoveItemTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testRemovableProperty() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No mandatory property def found.");
        }
        NodeType type = propDef.getDeclaringNodeType();
        CanRemoveItemTest.assertTrue((String)"NodeType.canRemoveIten(String itemName) must return true if itemName is nor a protected nor a mandatory property def.", (boolean)type.canRemoveItem(propDef.getName()));
    }

    public void testProtectedProperty() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No protected property def found.");
        }
        NodeType type = propDef.getDeclaringNodeType();
        CanRemoveItemTest.assertFalse((String)"NodeType.canRemoveIten(String itemName) must return false if itemName is a protected property def.", (boolean)type.canRemoveItem(propDef.getName()));
    }

    public void testMandatoryProperty() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, false, true);
        if (propDef == null) {
            throw new NotExecutableException("No mandatory property def found.");
        }
        NodeType type = propDef.getDeclaringNodeType();
        CanRemoveItemTest.assertFalse((String)"NodeType.canRemoveIten(String itemName) must return false if itemName is a mandatory property def.", (boolean)type.canRemoveItem(propDef.getName()));
    }

    public void testRemovableChildNode() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No mandatory property def found.");
        }
        NodeType type = nodeDef.getDeclaringNodeType();
        CanRemoveItemTest.assertTrue((String)"NodeType.canRemoveIten(String itemName) must return true if itemName is nor a protected nor a mandatory child node def.", (boolean)type.canRemoveItem(nodeDef.getName()));
    }

    public void testProtectedChildNode() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No mandatory property def found.");
        }
        NodeType type = nodeDef.getDeclaringNodeType();
        CanRemoveItemTest.assertFalse((String)"NodeType.canRemoveIten(String itemName) must return false if itemName is a protected child node def.", (boolean)type.canRemoveItem(nodeDef.getName()));
    }

    public void testMandatoryChildNode() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No mandatory property def found.");
        }
        NodeType type = nodeDef.getDeclaringNodeType();
        CanRemoveItemTest.assertFalse((String)"NodeType.canRemoveIten(String itemName) must return false if itemName is a mandatory child node def.", (boolean)type.canRemoveItem(nodeDef.getName()));
    }
}

