/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyNameTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 7, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No name property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value nameStringValue = this.superuser.getValueFactory().createValue("abc");
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Name and value is a StringValue that is convertible to a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameStringValue));
        Value noNameStringValue = this.superuser.getValueFactory().createValue("a:b:c");
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a StringValue that is not convertible to a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), noNameStringValue));
        Value nameBinaryValue = this.superuser.getValueFactory().createValue("abc", 2);
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Name and value is a UTF-8 BinaryValue that is convertible to a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameBinaryValue));
        Value noNameBinaryValue = this.superuser.getValueFactory().createValue("a:b:c", 2);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a UTF-8 BinaryValue that is not convertible to a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), noNameBinaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Name and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value namePathValue = this.superuser.getValueFactory().createValue("abc", 8);
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Name and value is a PathValue if Path is relative, is one element long and has no index", (boolean)nodeType.canSetProperty(propDef.getName(), namePathValue));
        Value noNamePathValue = this.superuser.getValueFactory().createValue("/abc", 8);
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Name and value is a PathValue if Path is not relative, is more than one element long or has an index", (boolean)nodeType.canSetProperty(propDef.getName(), noNamePathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 7, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple name property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        Value nameStringValue = this.superuser.getValueFactory().createValue("abc");
        Value[] nameStringValues = new Value[]{nameStringValue};
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Name and values are of type StringValue that are convertible to NameValues", (boolean)nodeType.canSetProperty(propDef.getName(), nameStringValues));
        Value notNameStringValue = this.superuser.getValueFactory().createValue("a:b:c");
        Value[] notNameStringValues = new Value[]{nameValue, notNameStringValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type StringValue that are not convertible to NameValues ", (boolean)nodeType.canSetProperty(propDef.getName(), notNameStringValues));
        Value nameBinaryValue = this.superuser.getValueFactory().createValue("abc", 2);
        Value[] nameBinaryValues = new Value[]{nameBinaryValue};
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Name and values are of type BinaryValue that are convertible to NameValues", (boolean)nodeType.canSetProperty(propDef.getName(), nameBinaryValues));
        Value notNameBinaryValue = this.superuser.getValueFactory().createValue("a:b:c", 2);
        Value[] notNameBinaryValues = new Value[]{nameValue, notNameBinaryValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type BinaryValue that are not convertible to NameValues", (boolean)nodeType.canSetProperty(propDef.getName(), notNameBinaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        Value[] dateValues = new Value[]{nameValue, dateValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        Value[] doubleValues = new Value[]{nameValue, doubleValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        Value[] longValues = new Value[]{nameValue, longValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        Value[] booleanValues = new Value[]{booleanValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value[] nameValues = new Value[]{nameValue};
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Name and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value namePathValue = this.superuser.getValueFactory().createValue("abc", 8);
        Value[] namePathValues = new Value[]{namePathValue};
        CanSetPropertyNameTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Name and values are of type PathValue if Path is relative, is one element long and has no index", (boolean)nodeType.canSetProperty(propDef.getName(), namePathValues));
        Value notNamePathValue = this.superuser.getValueFactory().createValue("/abc", 8);
        Value[] notNamePathValues = new Value[]{nameValue, notNamePathValue};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Name and values are of type PathValue if Path is not relative, is more than one element long or has an index", (boolean)nodeType.canSetProperty(propDef.getName(), notNamePathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 7, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No name property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No name property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 7, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple name property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple name property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyNameTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

