/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeDefTest
extends AbstractJCRTest {
    private Session session;
    private NodeTypeManager manager;
    private boolean foundMandatoryNode = false;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
        this.testRootNode = (Node)this.session.getItem(this.testRoot);
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testGetDeclaringNodeType() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType currentType = types.nextNodeType();
            NodeDefinition[] defsOfCurrentType = currentType.getChildNodeDefinitions();
            for (int i = 0; i < defsOfCurrentType.length; ++i) {
                NodeDefinition def = defsOfCurrentType[i];
                NodeType type = def.getDeclaringNodeType();
                NodeDefinition[] defs = type.getChildNodeDefinitions();
                boolean hasType = false;
                for (int j = 0; j < defs.length; ++j) {
                    if (!defs[j].getName().equals(def.getName())) continue;
                    hasType = true;
                    break;
                }
                NodeDefTest.assertTrue((String)"getDeclaringNodeType() must return the node which defines the corresponding child node def.", (boolean)hasType);
            }
        }
    }

    public void testIsAutoCreate() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] defs = type.getChildNodeDefinitions();
            for (int i = 0; i < defs.length; ++i) {
                if (!defs[i].isAutoCreated()) continue;
                NodeDefTest.assertFalse((String)"An auto create node must not be a residual set definition.", (boolean)defs[i].getName().equals("*"));
            }
        }
    }

    public void testIsMandatory() throws RepositoryException, NotExecutableException {
        this.traverse(this.testRootNode);
        if (!this.foundMandatoryNode) {
            throw new NotExecutableException("Workspace does not contain any node with a mandatory child node definition");
        }
    }

    public void testGetRequiredPrimaryTypes() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] defs = type.getChildNodeDefinitions();
            for (int i = 0; i < defs.length; ++i) {
                NodeDefTest.assertTrue((String)"getRequiredPrimaryTypes() must never return an empty array.", (defs[i].getRequiredPrimaryTypes().length > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testGetDefaultPrimaryTypes() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] defs = type.getChildNodeDefinitions();
            for (int i = 0; i < defs.length; ++i) {
                NodeDefinition def = defs[i];
                NodeType defaultType = def.getDefaultPrimaryType();
                if (defaultType == null) continue;
                NodeType[] requiredTypes = def.getRequiredPrimaryTypes();
                for (int j = 0; j < requiredTypes.length; ++j) {
                    NodeType requiredType = requiredTypes[j];
                    boolean isSubType = this.compareWithRequiredType(requiredType, defaultType);
                    NodeDefTest.assertTrue((String)"The NodeType returned by getDefaultPrimaryType or one of its supertypes must match all NodeTypes returned by getRequiredPrimaryTypes()", (boolean)isSubType);
                }
            }
        }
    }

    private void traverse(Node parentNode) throws RepositoryException {
        NodeIterator nodes = parentNode.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            NodeType primaryType = node.getPrimaryNodeType();
            this.checkMandatoryConstraint(node, primaryType);
            NodeType[] mixins = node.getMixinNodeTypes();
            for (int i = 0; i < mixins.length; ++i) {
                this.checkMandatoryConstraint(node, mixins[i]);
            }
            this.traverse(node);
        }
    }

    private void checkMandatoryConstraint(Node node, NodeType type) throws RepositoryException {
        NodeDefinition[] nodeDefs = type.getChildNodeDefinitions();
        for (int i = 0; i < nodeDefs.length; ++i) {
            NodeDefinition nodeDef = nodeDefs[i];
            if (!nodeDef.isMandatory()) continue;
            this.foundMandatoryNode = true;
            try {
                node.getNode(nodeDef.getName());
                continue;
            }
            catch (PathNotFoundException e) {
                NodeDefTest.fail((String)("Mandatory child " + nodeDef.getName() + " for " + node.getPath() + " does not exist."));
            }
        }
    }

    private boolean compareWithRequiredType(NodeType requiredType, NodeType defaultType) {
        if (defaultType.getName().equals(requiredType.getName())) {
            return true;
        }
        NodeType[] superTypes = defaultType.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            if (!superTypes[i].getName().equals(requiredType.getName())) continue;
            return true;
        }
        return false;
    }
}

