/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class EventTest
extends AbstractObservationTest {
    public void testGetNodePath() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        Node addedNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        EventTest.assertEquals((String)"Wrong number of events returned", (int)1, (int)events.length);
        String path = events[0].getPath();
        String absPath = addedNode.getPath();
        EventTest.assertEquals((String)"Path returned by getPath() is wrong", (String)absPath, (String)path);
    }

    public void testGetUserId() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        EventTest.assertEquals((String)"Wrong number of events returned", (int)1, (int)events.length);
        String userId = events[0].getUserID();
        String sessionUId = this.superuser.getUserID();
        EventTest.assertEquals((String)"UserId of event is not equal to userId of session", (String)userId, (String)sessionUId);
    }

    public void testGetType() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        EventTest.assertEquals((String)"Wrong number of events returned", (int)1, (int)events.length);
        int type = events[0].getType();
        EventTest.assertEquals((String)"Event did not return correct event type", (int)1, (int)type);
    }
}

