/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class WorkspaceOperationTest
extends AbstractObservationTest {
    public void testCopy() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult listener = new EventResult(this.log);
        this.addEventListener(listener, 1);
        this.superuser.getWorkspace().copy(this.testRoot + "/" + this.nodeName1, this.testRoot + "/" + this.nodeName3);
        Event[] events = listener.getEvents(5000L);
        this.removeEventListener(listener);
        this.checkNodeAdded(events, new String[]{this.nodeName3, this.nodeName3 + "/" + this.nodeName2}, null);
    }

    public void testRename() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.superuser.getWorkspace().move(n1.getPath(), this.testRoot + "/" + this.nodeName3);
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3}, new String[]{this.nodeName3 + "/" + this.nodeName2});
        this.checkNodeRemoved(removed, new String[]{this.nodeName1}, new String[]{this.nodeName1 + "/" + this.nodeName2});
    }

    public void testMove() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.superuser.getWorkspace().move(n1.getPath(), n3.getPath() + "/" + this.nodeName4);
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3 + "/" + this.nodeName4}, new String[]{this.nodeName3 + "/" + this.nodeName4 + "/" + this.nodeName2});
        this.checkNodeRemoved(removed, new String[]{this.nodeName1}, new String[]{this.nodeName1 + "/" + this.nodeName2});
    }
}

