/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.PropertyUtil;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class DerefQueryLevel1Test
extends AbstractQueryTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testDerefSinglePropWithNodeTest() throws RepositoryException, NotExecutableException {
        Property refProp = PropertyUtil.searchProp(this.session, this.testRootNode, 9, Boolean.FALSE);
        if (refProp == null) {
            throw new NotExecutableException("Workspace does not contain a node with a reference property.");
        }
        Node target = refProp.getNode();
        String xpath = this.createStatement(refProp, target.getName());
        this.executeDerefQuery(this.session, xpath, new Node[]{target});
    }

    public void testDerefSinglePropWithNodeStar() throws RepositoryException, NotExecutableException {
        Property refProp = PropertyUtil.searchProp(this.session, this.testRootNode, 9, Boolean.FALSE);
        if (refProp == null) {
            throw new NotExecutableException("Workspace does not contain a node with a reference property.");
        }
        Node target = refProp.getNode();
        String xpath = this.createStatement(refProp, "*");
        this.executeDerefQuery(this.session, xpath, new Node[]{target});
    }

    public void testDerefMultiPropWithNodeTest() throws RepositoryException, NotExecutableException {
        Property refProp = PropertyUtil.searchMultivalProp(this.testRootNode, 9);
        if (refProp == null) {
            throw new NotExecutableException("Workspace does not contain a node with a multivalue reference property.");
        }
        Value[] targets = refProp.getValues();
        Node[] targetNodes = new Node[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetNodes[i] = this.session.getNodeByUUID(targets[i].getString());
        }
        if (targetNodes.length == 0) {
            throw new NotExecutableException("Reference property does not contain a value");
        }
        String nodeName = targetNodes[0].getName();
        ArrayList<Node> resultNodes = new ArrayList<Node>();
        for (int i = 0; i < targetNodes.length; ++i) {
            if (!targetNodes[i].getName().equals(nodeName)) continue;
            resultNodes.add(targetNodes[i]);
        }
        targetNodes = resultNodes.toArray(new Node[resultNodes.size()]);
        String xpath = this.createStatement(refProp, nodeName);
        this.executeDerefQuery(this.session, xpath, targetNodes);
    }

    public void testDerefMultiPropWithNodeStar() throws RepositoryException, NotExecutableException {
        Property refProp = PropertyUtil.searchMultivalProp(this.testRootNode, 9);
        if (refProp == null) {
            throw new NotExecutableException("Workspace does not contain a node with a multivalue reference property.");
        }
        Value[] targets = refProp.getValues();
        Node[] targetNodes = new Node[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetNodes[i] = this.session.getNodeByUUID(targets[i].getString());
        }
        if (targetNodes.length == 0) {
            throw new NotExecutableException("Reference property does not contain a value");
        }
        String xpath = this.createStatement(refProp, "*");
        this.executeDerefQuery(this.session, xpath, targetNodes);
    }

    private String createStatement(Property refProperty, String nameTest) throws RepositoryException {
        StringBuffer stmt = new StringBuffer();
        stmt.append("/").append(this.jcrRoot).append(refProperty.getParent().getPath());
        stmt.append("/").append(this.jcrDeref).append("(@");
        stmt.append(refProperty.getName()).append(", '");
        stmt.append(nameTest).append("')");
        return stmt.toString();
    }

    private void executeDerefQuery(Session session, String xpath, Node[] nodes) throws NotExecutableException {
        try {
            this.executeXPathQuery(session, xpath, nodes);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException(e.getMessage());
        }
    }
}

