/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class QueryResultNodeIteratorTest
extends AbstractQueryTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
    }

    public void testGetSize() throws RepositoryException, NotExecutableException {
        long count;
        NodeIterator it = this.execute(this.testPath + "//*", "xpath").getNodes();
        long size = this.testRootNode.getNodes().getSize();
        if (size != -1L) {
            count = 0L;
            while (it.hasNext()) {
                it.nextNode();
                ++count;
            }
        } else {
            throw new NotExecutableException("NodeIterator.getSize() does not return size information.");
        }
        QueryResultNodeIteratorTest.assertEquals((String)"NodeIterator.getSize does not return correct number.", (long)size, (long)count);
    }

    public void testGetPosition() throws RepositoryException {
        QueryResult rs = this.execute(this.testPath + "//*", "xpath");
        NodeIterator it = rs.getNodes();
        QueryResultNodeIteratorTest.assertEquals((String)"Initial call to getPosition() must return 0.", (long)0L, (long)it.getPosition());
        int index = 0;
        while (it.hasNext()) {
            it.nextNode();
            QueryResultNodeIteratorTest.assertEquals((String)"Wrong position returned by getPosition()", (long)(++index), (long)it.getPosition());
        }
    }

    public void testGetPositionEmptyIterator() throws RepositoryException {
        QueryResult rs = this.execute(this.testPath + "/" + this.nodeName4, "xpath");
        NodeIterator it = rs.getNodes();
        QueryResultNodeIteratorTest.assertFalse((String)"NodeIterator must be empty.", (boolean)it.hasNext());
        QueryResultNodeIteratorTest.assertEquals((String)"Empty NodeIterator must return 0 on getPosition()", (long)0L, (long)it.getPosition());
    }

    public void testNoSuchElementException() throws RepositoryException {
        NodeIterator it = this.execute(this.testPath + "//*", "xpath").getNodes();
        while (it.hasNext()) {
            it.nextNode();
        }
        try {
            it.nextNode();
            QueryResultNodeIteratorTest.fail((String)"nextNode() must throw a NoSuchElementException when no nodes are available");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSkip() throws RepositoryException {
        String query = this.testPath + "//*";
        QueryResult rs = this.execute(query, "xpath");
        NodeIterator it = rs.getNodes();
        int count = 0;
        while (it.hasNext()) {
            it.nextNode();
            ++count;
        }
        if (count > 1) {
            rs = this.execute(query, "xpath");
            it = rs.getNodes();
            it.skip((long)(count - 1));
            it.nextNode();
            try {
                it.nextNode();
                QueryResultNodeIteratorTest.fail((String)"nextNode() must throw a NoSuchElementException when no nodes are available");
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            rs = this.execute(query, "xpath");
            it = rs.getNodes();
            try {
                it.skip((long)(count + 1));
                QueryResultNodeIteratorTest.fail((String)"skip() must throw a NoSuchElementException if one tries to skip past the end of the iterator");
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
    }
}

