/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class FrozenNodeTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.versionableNode.checkout();
    }

    public void testFrozenNodeUUUID() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode);
        String puuid = n.getProperty(this.jcrUUID).getValue().getString();
        String nuuid = n.getUUID();
        FrozenNodeTest.assertEquals((String)"jcr:uuid needs to be equal to the getUUID() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenChildNodeUUUID() throws RepositoryException {
        this.versionableNode.addNode("child");
        this.versionableNode.save();
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode).getNode("child");
        String puuid = n.getProperty(this.jcrUUID).getValue().getString();
        String nuuid = n.getUUID();
        FrozenNodeTest.assertEquals((String)"jcr:uuid needs to be equal to the getUUID() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenUUUID() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode);
        String fuuid = n.getProperty(this.jcrFrozenUuid).getValue().getString();
        String ruuid = this.versionableNode.getUUID();
        FrozenNodeTest.assertEquals((String)"jcr:frozenUuid needs to be equal to the getUUID() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenChildUUUID() throws RepositoryException {
        Node n1 = this.versionableNode.addNode("child");
        this.versionableNode.save();
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode).getNode("child");
        String fuuid = n.getProperty(this.jcrFrozenUuid).getValue().getString();
        String ruuid = n1.getUUID();
        FrozenNodeTest.assertEquals((String)"jcr:frozenUuid needs to be equal to the getUUID() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenNodeNodeType() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode);
        String puuid = n.getProperty(this.jcrPrimaryType).getValue().getString();
        String nuuid = n.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:primaryType needs to be equal to the getPrimaryNodeType() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenChildNodeNodeType() throws RepositoryException {
        this.versionableNode.addNode("child");
        this.versionableNode.save();
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode).getNode("child");
        String puuid = n.getProperty(this.jcrPrimaryType).getValue().getString();
        String nuuid = n.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:primaryType needs to be equal to the getPrimaryNodeType() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenNodeType() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode);
        String fuuid = n.getProperty("jcr:frozenPrimaryType").getValue().getString();
        String ruuid = this.versionableNode.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:frozenPrimaryType needs to be equal to the getPrimaryNodeType() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenChildNodeType() throws RepositoryException {
        Node n1 = this.versionableNode.addNode("child");
        this.versionableNode.save();
        Version v = this.versionableNode.checkin();
        Node n = v.getNode(this.jcrFrozenNode).getNode("child");
        String fuuid = n.getProperty("jcr:frozenPrimaryType").getValue().getString();
        String ruuid = n1.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:frozenPrimaryType needs to be equal to the getPrimaryNodeType() return value.", (String)ruuid, (String)fuuid);
    }
}

