/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class RemoveVersionTest
extends AbstractVersionTest {
    protected Node versionableNode2;
    protected Version version;
    protected Version version2;
    protected VersionHistory vHistory;

    protected void setUp() throws Exception {
        super.setUp();
        Version testV = this.versionableNode.checkin();
        this.versionableNode.checkout();
        this.versionableNode.checkin();
        this.versionableNode.checkout();
        this.versionableNode.checkin();
        try {
            this.versionableNode.getVersionHistory().removeVersion(testV.getName());
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException("Removing version is not supported: " + e.getMessage());
        }
        this.versionableNode.checkout();
        this.version = this.versionableNode.checkin();
        this.versionableNode.checkout();
        this.version2 = this.versionableNode.checkin();
        this.vHistory = this.versionableNode.getVersionHistory();
        try {
            this.versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName2, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            RemoveVersionTest.fail((String)("Failed to create a second versionable node: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.versionableNode2.remove();
            Object var2_1 = null;
            this.versionableNode2 = null;
            this.version = null;
            this.version2 = null;
            this.vHistory = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.versionableNode2 = null;
            this.version = null;
            this.version2 = null;
            this.vHistory = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    public void testRemovedInvalid() throws Exception {
        this.versionableNode.getVersionHistory().removeVersion(this.version.getName());
        try {
            this.version.getPredecessors();
            RemoveVersionTest.fail((String)"Removed version still operational.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRemoveVersionAdjustPredecessorSet() throws RepositoryException {
        ArrayList<String> predecPaths = new ArrayList<String>();
        Version[] predec = this.version.getPredecessors();
        for (int i = 0; i < predec.length; ++i) {
            predecPaths.add(predec[i].getPath());
        }
        this.vHistory.removeVersion(this.version.getName());
        Version[] predec2 = this.version2.getPredecessors();
        for (int i = 0; i < predec2.length; ++i) {
            if (predecPaths.remove(predec2[i].getPath())) continue;
            RemoveVersionTest.fail((String)"All predecessors of the removed version must be made predecessors of it's original successor version.");
        }
        if (!predecPaths.isEmpty()) {
            RemoveVersionTest.fail((String)"All predecessors of the removed version must be made predecessors of it's original successor version.");
        }
    }

    public void testRemoveVersionAdjustSucessorSet() throws RepositoryException {
        Version[] predec = this.version.getPredecessors();
        this.vHistory.removeVersion(this.version.getName());
        for (int i = 0; i < predec.length; ++i) {
            boolean isContained = false;
            Version[] succ = predec[i].getSuccessors();
            for (int j = 0; j < succ.length; ++j) {
                isContained |= succ[j].isSame((Item)this.version2);
            }
            if (isContained) continue;
            RemoveVersionTest.fail((String)"Removing a version must make all it's successor version to successors of the removed version's predecessors.");
        }
    }

    public void testRemoveInvalidVersion() throws RepositoryException, NotExecutableException {
        Version invalidV = this.versionableNode2.checkin();
        String invalidName = invalidV.getName();
        boolean found = false;
        for (int i = 0; i < 10 && !found; ++i) {
            try {
                this.vHistory.getVersion(invalidName);
                invalidName = invalidName + i;
                continue;
            }
            catch (VersionException e) {
                found = true;
            }
        }
        if (!found) {
            throw new NotExecutableException("Failed to create an invalid name in order to test the removal of versions.");
        }
        try {
            this.vHistory.removeVersion(invalidName);
            RemoveVersionTest.fail((String)"Removing a version that does not exist must fail with a VersionException.");
        }
        catch (VersionException e) {
            // empty catch block
        }
    }

    public void testReferentialIntegrityException() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName4, this.testNodeType);
        Value refValue = this.superuser.getValueFactory().createValue((Node)this.version);
        this.ensureCanSetProperty(n1, this.propertyName1, refValue);
        n1.setProperty(this.propertyName1, refValue);
        this.testRootNode.save();
        try {
            this.vHistory.removeVersion(this.version.getName());
            RemoveVersionTest.fail((String)"Method removeVersion() must throw a ReferentialIntegrityException if the version is the target of a REFERENCE property and the current Session has read access to that REFERENCE property");
        }
        catch (ReferentialIntegrityException referentialIntegrityException) {
            // empty catch block
        }
    }

    public void testRemoveAllBut2() throws RepositoryException {
        String baseVersion = this.versionableNode.getBaseVersion().getName();
        VersionHistory vh = this.versionableNode.getVersionHistory();
        VersionIterator vi = vh.getAllVersions();
        while (vi.hasNext()) {
            Version currenVersion = vi.nextVersion();
            String versionName = currenVersion.getName();
            if (versionName.equals("jcr:rootVersion") || versionName.equals(baseVersion)) continue;
            vh.removeVersion(versionName);
        }
    }

    public void testRemoveRootVersion() throws RepositoryException {
        try {
            this.versionableNode.getVersionHistory().getRootVersion().remove();
            RemoveVersionTest.fail((String)"Removal of root version should throw an exception.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRemoveBaseVersion() throws RepositoryException {
        try {
            this.versionableNode.getBaseVersion().remove();
            RemoveVersionTest.fail((String)"Removal of base version should throw an exception.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }
}

