/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.LazyItemIterator;
import org.apache.jackrabbit.jcr2spi.PropertyImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.WorkspaceImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.lock.LockManager;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.Update;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.jcr2spi.util.StateUtility;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl
extends ItemImpl
implements Node {
    private static Logger log = LoggerFactory.getLogger((Class)NodeImpl.class);
    private Name primaryTypeName;

    protected NodeImpl(SessionImpl session, NodeState state, ItemLifeCycleListener[] listeners) {
        super(session, state, listeners);
        Name nodeTypeName = state.getNodeTypeName();
        if (!session.getNodeTypeManager().hasNodeType(nodeTypeName)) {
            throw new IllegalArgumentException("Unknown nodetype " + LogUtil.saveGetJCRName(nodeTypeName, session.getNameResolver()));
        }
        this.primaryTypeName = nodeTypeName;
    }

    public String getName() throws RepositoryException {
        this.checkStatus();
        return this.session.getNameResolver().getJCRName(this.getQName());
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkStatus();
        visitor.visit((Node)this);
    }

    public boolean isNode() {
        return true;
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, null);
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        NodeImpl parentNode;
        this.checkIsWritable();
        Path nodePath = this.getQPath(relPath).getNormalizedPath();
        if (nodePath.getNameElement().getIndex() != 0) {
            String msg = "Illegal subscript specified: " + relPath;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (nodePath.getLength() == 1) {
            parentNode = this;
        } else {
            Path parentPath = nodePath.getAncestor(1);
            ItemManager itemMgr = this.getItemManager();
            if (itemMgr.nodeExists(parentPath)) {
                parentNode = (NodeImpl)itemMgr.getNode(parentPath);
            } else {
                if (itemMgr.propertyExists(parentPath)) {
                    String msg = "Cannot add a node to property " + LogUtil.safeGetJCRPath(parentPath, this.session.getPathResolver());
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                throw new PathNotFoundException("Cannot add a new node to a non-existing parent at " + LogUtil.safeGetJCRPath(parentPath, this.session.getPathResolver()));
            }
        }
        Name nodeName = nodePath.getNameElement().getName();
        Name ntName = primaryNodeTypeName == null ? null : this.getQName(primaryNodeTypeName);
        return parentNode.createNode(nodeName, ntName);
    }

    public synchronized void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.checkIsWritable();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("Child node ordering not supported on node " + this.safeGetJCRPath());
        }
        if (srcChildRelPath.equals(destChildRelPath)) {
            return;
        }
        if (!this.hasNode(srcChildRelPath)) {
            throw new ItemNotFoundException("Node " + this.safeGetJCRPath() + " has no child node with name " + srcChildRelPath);
        }
        if (destChildRelPath != null && !this.hasNode(destChildRelPath)) {
            throw new ItemNotFoundException("Node " + this.safeGetJCRPath() + " has no child node with name " + destChildRelPath);
        }
        Path.Element srcName = this.getReorderPath(srcChildRelPath).getNameElement();
        Path.Element beforeName = destChildRelPath == null ? null : this.getReorderPath(destChildRelPath).getNameElement();
        Operation op = ReorderNodes.create(this.getNodeState(), srcName, beforeName);
        this.session.getSessionItemStateManager().execute(op);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        int type = 0;
        if (value != null) {
            type = value.getType();
        }
        return this.setProperty(name, value, type);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Property prop;
        this.checkIsWritable();
        Name propName = this.getQName(name);
        if (this.hasProperty(propName)) {
            prop = this.getProperty(propName);
            Value v = type == 0 ? value : ValueHelper.convert((Value)value, (int)type, (ValueFactory)this.session.getValueFactory());
            prop.setValue(v);
        } else {
            if (value == null) {
                throw new ItemNotFoundException("Cannot remove a non-existing property.");
            }
            prop = this.createProperty(propName, value, type);
        }
        return prop;
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        return this.setProperty(name, values, type);
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Property prop;
        this.checkIsWritable();
        Name propName = this.getQName(name);
        if (this.hasProperty(propName)) {
            prop = this.getProperty(propName);
            Value[] vs = type == 0 ? values : ValueHelper.convert((Value[])values, (int)type, (ValueFactory)this.session.getValueFactory());
            prop.setValue(vs);
        } else {
            if (values == null) {
                throw new ItemNotFoundException("Cannot remove a non-existing property.");
            }
            prop = this.createProperty(propName, values, type);
        }
        return prop;
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values, 0);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] vs = type == 0 ? ValueHelper.convert((String[])values, (int)1, (ValueFactory)this.session.getValueFactory()) : ValueHelper.convert((String[])values, (int)type, (ValueFactory)this.session.getValueFactory());
        return this.setProperty(name, vs, type);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = value == null ? null : this.session.getValueFactory().createValue(value, 1);
        return this.setProperty(name, v, 0);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = value == null ? null : this.session.getValueFactory().createValue(value, type);
        return this.setProperty(name, v, type);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = value == null ? null : this.session.getValueFactory().createValue(value);
        return this.setProperty(name, v, 2);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, this.session.getValueFactory().createValue(value), 6);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, this.session.getValueFactory().createValue(value), 4);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, this.session.getValueFactory().createValue(value), 3);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = value == null ? null : this.session.getValueFactory().createValue(value);
        return this.setProperty(name, v, 5);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v;
        this.checkIsWritable();
        if (value == null) {
            v = null;
        } else {
            PropertyImpl.checkValidReference(value, 9, this.session.getNameResolver());
            v = this.session.getValueFactory().createValue(value);
        }
        return this.setProperty(name, v, 9);
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        this.checkStatus();
        NodeEntry nodeEntry = this.resolveRelativeNodePath(relPath);
        if (nodeEntry == null) {
            throw new PathNotFoundException(relPath);
        }
        try {
            return (Node)this.getItemManager().getItem(nodeEntry);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(relPath, (Throwable)e);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        this.checkStatus();
        try {
            return this.getItemManager().getChildNodes(this.getNodeEntry());
        }
        catch (ItemNotFoundException infe) {
            String msg = "Failed to list the child nodes of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "Failed to list the child nodes of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        this.checkStatus();
        ArrayList nodes = new ArrayList();
        this.accept((ItemVisitor)new ChildrenCollectorFilter(namePattern, nodes, true, false, 1));
        return new NodeIteratorAdapter(nodes);
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        this.checkStatus();
        PropertyEntry entry = this.resolveRelativePropertyPath(relPath);
        if (entry == null) {
            throw new PathNotFoundException(relPath);
        }
        try {
            return (Property)this.getItemManager().getItem(entry);
        }
        catch (AccessDeniedException e) {
            throw new PathNotFoundException(relPath);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(relPath);
        }
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.checkStatus();
        try {
            return this.getItemManager().getChildProperties(this.getNodeEntry());
        }
        catch (ItemNotFoundException infe) {
            String msg = "Failed to list the child properties of " + this.getPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "Failed to list the child properties of " + this.getPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        this.checkStatus();
        ArrayList properties = new ArrayList();
        this.accept((ItemVisitor)new ChildrenCollectorFilter(namePattern, properties, false, true, 1));
        return new PropertyIteratorAdapter(properties);
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.checkStatus();
        String name = this.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            throw new ItemNotFoundException("No primary item present on Node " + this.safeGetJCRPath());
        }
        if (this.hasProperty(name)) {
            return this.getProperty(name);
        }
        if (this.hasNode(name)) {
            return this.getNode(name);
        }
        throw new ItemNotFoundException("Primary item " + name + " does not exist on Node " + this.safeGetJCRPath());
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkStatus();
        String uuid = this.getNodeState().getUniqueID();
        if (uuid == null || !this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new UnsupportedRepositoryOperationException();
        }
        return uuid;
    }

    public int getIndex() throws RepositoryException {
        this.checkStatus();
        int index = this.getNodeEntry().getIndex();
        if (index == 0) {
            throw new RepositoryException("Error while retrieving index.");
        }
        return index;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        this.checkStatus();
        List<PropertyId> refs = Arrays.asList(this.getNodeState().getNodeReferences());
        return new LazyItemIterator(this.getItemManager(), this.session.getHierarchyManager(), refs.iterator());
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        this.checkStatus();
        NodeEntry nodeEntry = this.resolveRelativeNodePath(relPath);
        return nodeEntry != null && this.getItemManager().itemExists(nodeEntry);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        this.checkStatus();
        PropertyEntry childEntry = this.resolveRelativePropertyPath(relPath);
        return childEntry != null && this.getItemManager().itemExists(childEntry);
    }

    private boolean hasProperty(Name propertyName) {
        return this.getNodeEntry().hasPropertyEntry(propertyName);
    }

    public boolean hasNodes() throws RepositoryException {
        this.checkStatus();
        return this.getItemManager().hasChildNodes(this.getNodeEntry());
    }

    public boolean hasProperties() throws RepositoryException {
        this.checkStatus();
        return this.getItemManager().hasChildProperties(this.getNodeEntry());
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.checkStatus();
        return this.session.getNodeTypeManager().getNodeType(this.primaryTypeName);
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.checkStatus();
        Name[] mixinNames = this.getNodeState().getMixinTypeNames();
        NodeType[] nta = new NodeType[mixinNames.length];
        for (int i = 0; i < mixinNames.length; ++i) {
            nta[i] = this.session.getNodeTypeManager().getNodeType(mixinNames[i]);
        }
        return nta;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        this.checkStatus();
        if (this.session.getNameResolver().getJCRName(this.primaryTypeName).equals(nodeTypeName)) {
            return true;
        }
        return this.isNodeType(this.getQName(nodeTypeName));
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkIsWritable();
        Name mixinQName = this.getQName(mixinName);
        List mixinValue = this.getMixinTypes();
        if (!mixinValue.contains(mixinQName)) {
            if (!this.canAddMixin(mixinQName)) {
                throw new ConstraintViolationException("Cannot add '" + mixinName + "' mixin type.");
            }
            mixinValue.add(mixinQName);
            Operation op = SetMixin.create(this.getNodeState(), mixinValue.toArray(new Name[mixinValue.size()]));
            this.session.getSessionItemStateManager().execute(op);
        }
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyIterator iter;
        EffectiveNodeType entRemaining;
        this.checkIsWritable();
        Name ntName = this.getQName(mixinName);
        List mixinValue = this.getMixinTypes();
        if (!mixinValue.remove(ntName)) {
            throw new NoSuchNodeTypeException("Cannot remove mixin '" + mixinName + "': Nodetype is not present on this node.");
        }
        NodeTypeImpl mixin = this.session.getNodeTypeManager().getNodeType(ntName);
        if (mixin.isNodeType(NameConstants.MIX_REFERENCEABLE) && !(entRemaining = this.getRemainingENT(mixinValue)).includesNodeType(NameConstants.MIX_REFERENCEABLE) && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException("Mixin type " + mixinName + " can not be removed: the node is being referenced through at least one property of type REFERENCE");
        }
        if (mixin.isNodeType(NameConstants.MIX_LOCKABLE) && !(entRemaining = this.getRemainingENT(mixinValue)).includesNodeType(NameConstants.MIX_LOCKABLE) && this.isLocked()) {
            throw new ConstraintViolationException(mixinName + " can not be removed: the node is locked.");
        }
        Name[] mixins = mixinValue.toArray(new Name[mixinValue.size()]);
        Operation op = SetMixin.create(this.getNodeState(), mixins);
        this.session.getSessionItemStateManager().execute(op);
    }

    private List getMixinTypes() {
        Name[] mixinValue;
        if (this.getNodeState().getStatus() == 1) {
            mixinValue = this.getNodeState().getMixinTypeNames();
        } else {
            try {
                PropertyEntry pe = this.getNodeEntry().getPropertyEntry(NameConstants.JCR_MIXINTYPES);
                mixinValue = pe != null ? StateUtility.getMixinNames(pe.getPropertyState()) : this.getNodeState().getMixinTypeNames();
            }
            catch (RepositoryException e) {
                log.warn("Internal error", (Throwable)e);
                mixinValue = new Name[]{};
            }
        }
        ArrayList<Name> l = new ArrayList<Name>();
        l.addAll(Arrays.asList(mixinValue));
        return l;
    }

    private EffectiveNodeType getRemainingENT(List remainingMixins) throws ConstraintViolationException, NoSuchNodeTypeException {
        Name[] allRemaining = remainingMixins.toArray(new Name[remainingMixins.size() + 1]);
        allRemaining[remainingMixins.size()] = this.primaryTypeName;
        return this.session.getEffectiveNodeTypeProvider().getEffectiveNodeType(allRemaining);
    }

    public boolean canAddMixin(String mixinName) throws RepositoryException {
        if (!this.isWritable()) {
            return false;
        }
        try {
            this.session.getValidator().checkIsWritable(this.getNodeState(), 47);
            return this.canAddMixin(this.getQName(mixinName));
        }
        catch (LockException e) {
            log.debug("Cannot add mixin '" + mixinName + "': " + e.getMessage());
            return false;
        }
        catch (VersionException e) {
            log.debug("Cannot add mixin '" + mixinName + "': " + e.getMessage());
            return false;
        }
        catch (ConstraintViolationException e) {
            log.debug("Cannot add mixin '" + mixinName + "': " + e.getMessage());
            return false;
        }
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.checkStatus();
        QNodeDefinition qnd = this.getNodeState().getDefinition();
        return this.session.getNodeTypeManager().getNodeDefinition(qnd);
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        this.checkIsVersionable();
        this.checkHasPendingChanges();
        this.checkIsLocked();
        if (this.isCheckedOut()) {
            NodeEntry newVersion = this.session.getVersionManager().checkin(this.getNodeState());
            return (Version)this.getItemManager().getItem(newVersion);
        }
        log.debug("Node " + this.safeGetJCRPath() + " is already checked in.");
        return this.getBaseVersion();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.checkIsVersionable();
        this.checkIsLocked();
        if (!this.isCheckedOut()) {
            this.session.getVersionManager().checkout(this.getNodeState());
        } else {
            log.debug("Node " + this.safeGetJCRPath() + " is already checked out.");
        }
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.resolveMergeConflict(version, true);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.resolveMergeConflict(version, false);
    }

    private void resolveMergeConflict(Version version, boolean done) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkIsVersionable();
        this.checkHasPendingChanges();
        this.checkIsLocked();
        if (!this.isCheckedOut()) {
            String msg = "Unable to resolve merge conflict. Node is checked-in: " + this.safeGetJCRPath();
            log.error(msg);
            throw new VersionException(msg);
        }
        boolean isConflicting = false;
        if (this.hasProperty(NameConstants.JCR_MERGEFAILED)) {
            Value[] vals = this.getProperty(NameConstants.JCR_MERGEFAILED).getValues();
            for (int i = 0; i < vals.length && !isConflicting; ++i) {
                isConflicting = vals[i].getString().equals(version.getUUID());
            }
        }
        if (!isConflicting) {
            String msg = "Unable to resolve merge conflict. Specified version is not in jcr:mergeFailed property: " + this.safeGetJCRPath();
            log.error(msg);
            throw new VersionException(msg);
        }
        NodeState versionState = this.session.getVersionState(version);
        this.session.getVersionManager().resolveMergeConflict(this.getNodeState(), versionState, done);
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        this.checkIsWritable();
        this.checkSessionHasPendingChanges();
        if (this.session.getWorkspace().getName().equals(srcWorkspaceName)) {
            return;
        }
        try {
            this.getCorrespondingNodePath(srcWorkspaceName);
        }
        catch (ItemNotFoundException e) {
            return;
        }
        Operation op = Update.create(this.getNodeState(), srcWorkspaceName);
        ((WorkspaceImpl)this.session.getWorkspace()).getUpdatableItemStateManager().execute(op);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.checkIsWritable();
        this.checkSessionHasPendingChanges();
        if (this.session.getWorkspace().getName().equals(srcWorkspace)) {
            return NodeIteratorAdapter.EMPTY;
        }
        this.session.checkAccessibleWorkspace(srcWorkspace);
        Iterator failedIds = this.session.getVersionManager().merge(this.getNodeState(), srcWorkspace, bestEffort);
        return new LazyItemIterator(this.getItemManager(), this.session.getHierarchyManager(), failedIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.checkStatus();
        SessionImpl srcSession = null;
        try {
            String correspondingPath;
            srcSession = this.session.switchWorkspace(workspaceName);
            NodeImpl referenceableNode = this;
            while (referenceableNode.getDepth() != 0 && !referenceableNode.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                referenceableNode = (NodeImpl)referenceableNode.getParent();
            }
            if (referenceableNode.getDepth() == 0) {
                if (!srcSession.getItemManager().nodeExists(this.getQPath())) {
                    throw new ItemNotFoundException("No corresponding path found in workspace " + workspaceName + "(" + this.safeGetJCRPath() + ")");
                }
                correspondingPath = this.getPath();
            } else {
                Node correspNode = srcSession.getNodeByUUID(referenceableNode.getUUID());
                if (referenceableNode == this) {
                    correspondingPath = correspNode.getPath();
                } else {
                    Path p = referenceableNode.getQPath().computeRelativePath(this.getQPath());
                    String relPath = this.session.getPathResolver().getJCRPath(p);
                    if (!correspNode.hasNode(relPath)) {
                        throw new ItemNotFoundException("No corresponding path found in workspace " + workspaceName + "(" + this.safeGetJCRPath() + ")");
                    }
                    correspondingPath = correspNode.getNode(relPath).getPath();
                }
            }
            String string = correspondingPath;
            return string;
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public boolean isCheckedOut() throws RepositoryException {
        this.checkStatus();
        if (this.isNew()) {
            return true;
        }
        return this.session.getVersionManager().isCheckedOut(this.getNodeState());
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.checkSessionHasPendingChanges();
        Version v = this.getVersionHistory().getVersion(versionName);
        this.restore(this, null, v, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.checkSessionHasPendingChanges();
        this.restore(this, null, version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.checkSessionHasPendingChanges();
        if (this.hasNode(relPath)) {
            this.getNode(relPath).restore(version, removeExisting);
        } else {
            Path nPath = this.getQPath(relPath);
            Path parentPath = nPath.getAncestor(1);
            ItemManager itemMgr = this.getItemManager();
            if (itemMgr.nodeExists(parentPath)) {
                Node parent = itemMgr.getNode(parentPath);
                Path relQPath = parentPath.computeRelativePath(nPath);
                NodeImpl parentNode = (NodeImpl)parent;
                this.restore(parentNode, relQPath, version, removeExisting);
            } else {
                if (itemMgr.propertyExists(parentPath)) {
                    throw new ConstraintViolationException("Cannot restore to a parent presenting a property (relative path = '" + relPath + "'");
                }
                throw new PathNotFoundException("Cannot restore to relative path '" + relPath + ": Ancestor does not exist.");
            }
        }
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.checkSessionHasPendingChanges();
        Version v = this.getVersionHistory().getVersionByLabel(versionLabel);
        if (v == null) {
            throw new VersionException("No version for label " + versionLabel + " found.");
        }
        this.restore(this, null, v, removeExisting);
    }

    private void restore(NodeImpl targetNode, Path relQPath, Version version, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        if (relQPath == null) {
            targetNode.checkIsVersionable();
            VersionHistory vH = targetNode.getVersionHistory();
            if (!vH.isSame((Item)version.getContainingHistory())) {
                throw new VersionException("Version " + version + " does not correspond to the restore target.");
            }
            if (vH.getRootVersion().isSame((Item)version)) {
                throw new VersionException("Attempt to restore root version.");
            }
            targetNode.checkIsWritable();
            targetNode.checkIsLocked();
        } else {
            if (!targetNode.isCheckedOut()) {
                throw new VersionException("Parent " + targetNode.safeGetJCRPath() + " for non-existing restore target '" + LogUtil.safeGetJCRPath(relQPath, this.session.getPathResolver()) + "' must be checked out.");
            }
            targetNode.checkIsLocked();
        }
        NodeState versionState = this.session.getVersionState(version);
        this.session.getVersionManager().restore(targetNode.getNodeState(), relQPath, versionState, removeExisting);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkIsVersionable();
        return (VersionHistory)this.getProperty(NameConstants.JCR_VERSIONHISTORY).getNode();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkIsVersionable();
        return (Version)this.getProperty(NameConstants.JCR_BASEVERSION).getNode();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.lock(isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.checkIsLockable();
        this.checkHasPendingChanges();
        return this.session.getLockManager().lock(this.getNodeState(), isDeep, isSessionScoped, timeoutHint, ownerHint);
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkStatus();
        return this.session.getLockManager().getLock(this.getNodeState());
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.checkIsLockable();
        this.checkHasPendingChanges();
        this.session.getLockManager().unlock(this.getNodeState());
    }

    public boolean holdsLock() throws RepositoryException {
        this.checkStatus();
        if (this.isNew() || !this.isNodeType(NameConstants.MIX_LOCKABLE)) {
            return false;
        }
        LockManager lMgr = this.session.getLockManager();
        return lMgr.isLocked(this.getNodeState()) && lMgr.getLock(this.getNodeState()).getNode().isSame((Item)this);
    }

    public boolean isLocked() throws RepositoryException {
        this.checkStatus();
        return this.session.getLockManager().isLocked(this.getNodeState());
    }

    boolean isNodeType(Name qName) throws RepositoryException {
        if (qName.equals(this.primaryTypeName)) {
            return true;
        }
        Name[] mixins = this.getNodeState().getMixinTypeNames();
        for (int i = 0; i < mixins.length; ++i) {
            if (!mixins[i].equals(qName)) continue;
            return true;
        }
        if (this.getNodeState().getStatus() == 4 && this.session.getNodeTypeManager().getNodeType(qName).isMixin()) {
            return false;
        }
        EffectiveNodeType effnt = this.session.getEffectiveNodeTypeProvider().getEffectiveNodeType(this.getNodeState().getNodeTypeNames());
        return effnt.includesNodeType(qName);
    }

    Name getQName() throws RepositoryException {
        if (this.getNodeState().isRoot()) {
            return NameConstants.ROOT;
        }
        return this.getNodeState().getName();
    }

    private void checkSessionHasPendingChanges() throws RepositoryException {
        this.session.checkHasPendingChanges();
    }

    private void checkHasPendingChanges() throws InvalidItemStateException, RepositoryException {
        if (this.hasPendingChanges()) {
            String msg = "Node has pending changes: " + this.getPath();
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
    }

    private boolean hasPendingChanges() {
        return this.isModified() || this.isNew();
    }

    private void checkIsLockable() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkStatus();
        if (!this.isNodeType(NameConstants.MIX_LOCKABLE)) {
            String msg = "Unable to perform locking operation on non-lockable node: " + this.getPath();
            log.debug(msg);
            throw new LockException(msg);
        }
    }

    void checkIsLocked() throws LockException, RepositoryException {
        if (this.isNew()) {
            return;
        }
        this.session.getLockManager().checkLock(this.getNodeState());
    }

    private void checkIsVersionable() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkStatus();
        if (!this.isNodeType(NameConstants.MIX_VERSIONABLE)) {
            String msg = "Unable to perform versioning operation on non versionable node: " + this.getPath();
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
    }

    private synchronized Node createNode(Name nodeName, Name nodeTypeName) throws ItemExistsException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        QNodeDefinition definition = this.session.getItemDefinitionProvider().getQNodeDefinition(this.getNodeState().getAllNodeTypeNames(), nodeName, nodeTypeName);
        if (nodeTypeName == null) {
            nodeTypeName = definition.getDefaultPrimaryType();
        }
        Operation an = AddNode.create(this.getNodeState(), nodeName, nodeTypeName, null);
        this.session.getSessionItemStateManager().execute(an);
        List addedStates = ((AddNode)an).getAddedStates();
        ItemState nState = (ItemState)addedStates.get(0);
        return (Node)this.getItemManager().getItem(nState.getHierarchyEntry());
    }

    protected Property getProperty(Name qName) throws PathNotFoundException, RepositoryException {
        this.checkStatus();
        try {
            PropertyEntry pEntry = this.getNodeEntry().getPropertyEntry(qName, true);
            if (pEntry == null) {
                throw new PathNotFoundException(LogUtil.saveGetJCRName(qName, this.session.getNameResolver()));
            }
            return (Property)this.getItemManager().getItem(pEntry);
        }
        catch (AccessDeniedException e) {
            throw new PathNotFoundException(LogUtil.saveGetJCRName(qName, this.session.getNameResolver()));
        }
    }

    private Property createProperty(Name qName, Value value, int type) throws ConstraintViolationException, RepositoryException {
        QValue qvs;
        QPropertyDefinition def = this.getApplicablePropertyDefinition(qName, type, false);
        int targetType = def.getRequiredType();
        if (targetType == 0) {
            targetType = type;
        }
        if (targetType == 0) {
            qvs = ValueFormat.getQValue((Value)value, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
            targetType = qvs.getType();
        } else {
            Value targetValue = ValueHelper.convert((Value)value, (int)targetType, (ValueFactory)this.session.getValueFactory());
            qvs = ValueFormat.getQValue((Value)targetValue, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
        }
        return this.createProperty(qName, targetType, def, new QValue[]{qvs});
    }

    private Property createProperty(Name qName, Value[] values, int type) throws ConstraintViolationException, RepositoryException {
        QPropertyDefinition def = this.getApplicablePropertyDefinition(qName, type, true);
        int targetType = def.getRequiredType();
        if (targetType == 0) {
            if (type == 0) {
                if (values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] == null) continue;
                        targetType = values[i].getType();
                        break;
                    }
                }
                if (targetType == 0) {
                    targetType = 1;
                }
            } else {
                targetType = type;
            }
        }
        Value[] targetValues = ValueHelper.convert((Value[])values, (int)targetType, (ValueFactory)this.session.getValueFactory());
        QValue[] qvs = ValueFormat.getQValues((Value[])targetValues, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
        return this.createProperty(qName, targetType, def, qvs);
    }

    private Property createProperty(Name qName, int type, QPropertyDefinition def, QValue[] qvs) throws ConstraintViolationException, RepositoryException {
        Operation op = AddProperty.create(this.getNodeState(), qName, type, def, qvs);
        this.session.getSessionItemStateManager().execute(op);
        return this.getProperty(qName);
    }

    private Name getQName(String jcrName) throws RepositoryException {
        Name qName;
        try {
            qName = this.session.getNameResolver().getQName(jcrName);
        }
        catch (NameException upe) {
            throw new RepositoryException("invalid name: " + jcrName, (Throwable)upe);
        }
        return qName;
    }

    private boolean canAddMixin(Name mixinName) throws NoSuchNodeTypeException, ConstraintViolationException {
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(mixinName);
        if (!mixin.isMixin()) {
            log.error(mixin.getName() + ": not a mixin node type");
            return false;
        }
        NodeTypeImpl primaryType = ntMgr.getNodeType(this.primaryTypeName);
        if (primaryType.isNodeType(mixinName)) {
            log.debug(mixin.getName() + ": already contained in primary node type");
            return false;
        }
        Name[] existingNts = this.getNodeState().getNodeTypeNames();
        EffectiveNodeType entExisting = this.session.getEffectiveNodeTypeProvider().getEffectiveNodeType(existingNts);
        if (!entExisting.supportsMixin(mixinName)) {
            log.debug(mixin.getName() + ": not supported on node type " + this.primaryTypeName);
            return false;
        }
        if (entExisting.includesNodeType(mixinName)) {
            log.debug(mixin.getName() + ": already contained in mixin types");
            return false;
        }
        Name[] resultingNts = new Name[existingNts.length + 1];
        System.arraycopy(existingNts, 0, resultingNts, 0, existingNts.length);
        resultingNts[existingNts.length] = mixinName;
        this.session.getEffectiveNodeTypeProvider().getEffectiveNodeType(resultingNts);
        return true;
    }

    private NodeState getNodeState() {
        return (NodeState)this.getItemState();
    }

    private NodeEntry getNodeEntry() {
        return (NodeEntry)this.getItemState().getHierarchyEntry();
    }

    private Path getReorderPath(String relativePath) throws RepositoryException {
        try {
            Path p = this.session.getPathResolver().getQPath(relativePath);
            if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                throw new RepositoryException("Invalid relative path: " + relativePath);
            }
            return p;
        }
        catch (NameException e) {
            String msg = "Invalid relative path: " + relativePath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private Path getQPath(String relativePath) throws RepositoryException {
        try {
            Path p = this.session.getPathResolver().getQPath(relativePath);
            return this.getQPath(p);
        }
        catch (NameException e) {
            String msg = "Invalid relative path: " + relativePath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private Path getQPath(Path relativePath) throws RepositoryException {
        if (relativePath.getLength() == 1 && relativePath.getNameElement() == this.session.getPathFactory().getCurrentElement()) {
            return this.getQPath();
        }
        return this.session.getPathFactory().create(this.getQPath(), relativePath, true);
    }

    private NodeEntry resolveRelativeNodePath(String relPath) throws RepositoryException {
        NodeEntry targetEntry = null;
        try {
            Path rp = this.session.getPathResolver().getQPath(relPath);
            if (rp.getLength() == 1) {
                Path.Element pe = rp.getNameElement();
                targetEntry = pe.denotesCurrent() ? this.getNodeEntry() : (pe.denotesParent() ? this.getNodeEntry().getParent() : this.getNodeEntry().getNodeEntry(pe.getName(), pe.getNormalizedIndex(), true));
            } else {
                Path p = this.getQPath(rp);
                targetEntry = this.session.getHierarchyManager().getNodeEntry(p.getCanonicalPath());
            }
        }
        catch (PathNotFoundException e) {
        }
        catch (NameException e) {
            String msg = "Invalid relative path: " + relPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return targetEntry;
    }

    private PropertyEntry resolveRelativePropertyPath(String relPath) throws RepositoryException {
        PropertyEntry targetEntry = null;
        try {
            Path rp = this.session.getPathResolver().getQPath(relPath);
            if (rp.getLength() == 1 && rp.getNameElement().denotesName()) {
                Name propName = rp.getNameElement().getName();
                targetEntry = this.getNodeEntry().getPropertyEntry(propName, true);
            } else {
                Path p = this.getQPath(rp).getCanonicalPath();
                try {
                    targetEntry = this.session.getHierarchyManager().getPropertyEntry(p);
                }
                catch (PathNotFoundException e) {}
            }
        }
        catch (NameException e) {
            String msg = "failed to resolve property path " + relPath + " relative to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return targetEntry;
    }

    private QPropertyDefinition getApplicablePropertyDefinition(Name propertyName, int type, boolean multiValued) throws ConstraintViolationException, RepositoryException {
        return this.session.getItemDefinitionProvider().getQPropertyDefinition(this.getNodeState().getAllNodeTypeNames(), propertyName, type, multiValued);
    }
}

