/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl
implements Property {
    private static Logger log = LoggerFactory.getLogger((Class)PropertyImpl.class);
    public static final int UNDEFINED_PROPERTY_LENGTH = -1;

    public PropertyImpl(SessionImpl session, PropertyState state, ItemLifeCycleListener[] listeners) {
        super(session, state, listeners);
    }

    public String getName() throws RepositoryException {
        this.checkStatus();
        Name name = this.getQName();
        return this.session.getNameResolver().getJCRName(name);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkStatus();
        visitor.visit((Property)this);
    }

    public boolean isNode() {
        return false;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int valueType = value != null ? value.getType() : 0;
        int reqType = this.getRequiredType(valueType);
        this.setValue(value, reqType);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, RepositoryException {
        int targetType;
        this.checkIsWritable(true);
        int valueType = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (valueType == 0) {
                    valueType = values[i].getType();
                    continue;
                }
                if (valueType == values[i].getType()) continue;
                String msg = "Inhomogeneous type of values (" + this.safeGetJCRPath() + ")";
                log.debug(msg);
                throw new ValueFormatException(msg);
            }
        }
        if ((targetType = this.getDefinition().getRequiredType()) == 0) {
            targetType = valueType == 0 ? 1 : valueType;
        }
        QValue[] qValues = null;
        if (values != null) {
            Value[] vs = ValueHelper.convert((Value[])values, (int)targetType, (ValueFactory)this.session.getValueFactory());
            qValues = ValueFormat.getQValues((Value[])vs, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
        }
        this.setInternalValues(qValues, targetType);
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(1);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(true);
        int reqType = this.getRequiredType(1);
        QValue[] qValues = null;
        if (values != null) {
            qValues = new QValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                String string = values[i];
                QValue qValue = null;
                if (string != null) {
                    if (reqType != 1) {
                        Value v = ValueHelper.convert((String)string, (int)reqType, (ValueFactory)this.session.getValueFactory());
                        qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
                    } else {
                        qValue = this.session.getQValueFactory().create(string, 1);
                    }
                }
                qValues[i] = qValue;
            }
        }
        this.setInternalValues(qValues, reqType);
    }

    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(2);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    public void setValue(long value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(3);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    public void setValue(double value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(4);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(5);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(6);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(9);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            PropertyImpl.checkValidReference(value, reqType, this.session.getNameResolver());
            QValue qValue = this.session.getQValueFactory().create(value.getUUID(), 9);
            this.setInternalValues(new QValue[]{qValue}, reqType);
        }
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        QValue value = this.getQValue();
        return ValueFormat.getJCRValue((QValue)value, (NamePathResolver)this.session.getNamePathResolver(), (ValueFactory)this.session.getJcrValueFactory());
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        QValue[] qValues = this.getQValues();
        Value[] values = new Value[qValues.length];
        for (int i = 0; i < qValues.length; ++i) {
            values[i] = ValueFormat.getJCRValue((QValue)qValues[i], (NamePathResolver)this.session.getNamePathResolver(), (ValueFactory)this.session.getJcrValueFactory());
        }
        return values;
    }

    public String getString() throws ValueFormatException, RepositoryException {
        return this.getValue().getString();
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        return this.getValue().getStream();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        return this.getValue().getDouble();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return this.getValue().getBoolean();
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        QValue value = this.getQValue();
        if (value.getType() == 9) {
            return this.session.getNodeByUUID(value.getString());
        }
        throw new ValueFormatException("Property must be of type REFERENCE (" + this.safeGetJCRPath() + ")");
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        return this.getLength(this.getQValue());
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        QValue[] values = this.getQValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = this.getLength(values[i]);
        }
        return lengths;
    }

    private long getLength(QValue value) throws RepositoryException {
        long length;
        switch (value.getType()) {
            case 7: 
            case 8: {
                Value jcrValue = ValueFormat.getJCRValue((QValue)value, (NamePathResolver)this.session.getNamePathResolver(), (ValueFactory)this.session.getJcrValueFactory());
                length = jcrValue.getString().length();
                break;
            }
            default: {
                length = value.getLength();
            }
        }
        return length;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.checkStatus();
        QPropertyDefinition qpd = this.getPropertyState().getDefinition();
        return this.session.getNodeTypeManager().getPropertyDefinition(qpd);
    }

    public int getType() throws RepositoryException {
        this.checkStatus();
        return this.getPropertyState().getType();
    }

    Name getQName() {
        return this.getPropertyState().getName();
    }

    private void checkIsWritable(boolean multiValues) throws RepositoryException {
        this.checkIsWritable();
        if (this.isMultiple() != multiValues) {
            throw new ValueFormatException(this.getPath() + "Multivalue definition of " + this.safeGetJCRPath() + " does not match to given value(s).");
        }
    }

    private boolean isMultiple() {
        return this.getPropertyState().isMultiValued();
    }

    private int getRequiredType(int defaultType) throws RepositoryException {
        int reqType = this.getDefinition().getRequiredType();
        if (reqType == 0) {
            reqType = defaultType == 0 ? 1 : defaultType;
        }
        return reqType;
    }

    private QValue getQValue() throws ValueFormatException, RepositoryException {
        this.checkStatus();
        if (this.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        return this.getPropertyState().getValue();
    }

    private QValue[] getQValues() throws ValueFormatException, RepositoryException {
        this.checkStatus();
        if (!this.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued and can therefore only be retrieved as single value");
        }
        return this.getPropertyState().getValues();
    }

    private void setValue(Value value, int requiredType) throws RepositoryException {
        QValue qValue;
        if (requiredType == 0) {
            throw new IllegalArgumentException("Property type of a value cannot be undefined (" + this.safeGetJCRPath() + ").");
        }
        if (value == null) {
            this.setInternalValues(null, requiredType);
            return;
        }
        if (requiredType != value.getType()) {
            Value v = ValueHelper.convert((Value)value, (int)requiredType, (ValueFactory)this.session.getValueFactory());
            qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
        } else {
            qValue = ValueFormat.getQValue((Value)value, (NamePathResolver)this.session.getNamePathResolver(), (QValueFactory)this.session.getQValueFactory());
        }
        this.setInternalValues(new QValue[]{qValue}, requiredType);
    }

    private void setInternalValues(QValue[] qValues, int valueType) throws ConstraintViolationException, RepositoryException {
        if (qValues == null) {
            this.remove();
            return;
        }
        Operation op = SetPropertyValue.create(this.getPropertyState(), qValues, valueType);
        this.session.getSessionItemStateManager().execute(op);
    }

    private PropertyState getPropertyState() {
        return (PropertyState)this.getItemState();
    }

    static void checkValidReference(Node value, int propertyType, NameResolver resolver) throws ValueFormatException, RepositoryException {
        if (propertyType == 9) {
            String jcrName = resolver.getJCRName(NameConstants.MIX_REFERENCEABLE);
            if (!value.isNodeType(jcrName)) {
                throw new ValueFormatException("Target node must be of node type mix:referenceable");
            }
        } else {
            throw new ValueFormatException("Property must be of type REFERENCE.");
        }
    }
}

