/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntryImpl;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChildNodeAttic {
    private static Logger log = LoggerFactory.getLogger((Class)ChildNodeAttic.class);
    private Set attic = new HashSet();

    ChildNodeAttic() {
    }

    boolean isEmpty() {
        return this.attic.isEmpty();
    }

    boolean contains(Name name, int index) {
        Iterator it = this.attic.iterator();
        while (it.hasNext()) {
            NodeEntryImpl ne = (NodeEntryImpl)it.next();
            if (!ne.matches(name, index)) continue;
            return true;
        }
        return false;
    }

    boolean contains(Name name, int index, String uniqueId) {
        Iterator it = this.attic.iterator();
        while (it.hasNext()) {
            NodeEntryImpl ne = (NodeEntryImpl)it.next();
            if (uniqueId != null && uniqueId.equals(ne.getUniqueID())) {
                return true;
            }
            if (!ne.matches(name, index)) continue;
            return true;
        }
        return false;
    }

    List get(Name name) {
        ArrayList<NodeEntryImpl> l = new ArrayList<NodeEntryImpl>();
        Iterator it = this.attic.iterator();
        while (it.hasNext()) {
            NodeEntryImpl ne = (NodeEntryImpl)it.next();
            if (!ne.matches(name)) continue;
            l.add(ne);
        }
        return l;
    }

    NodeEntry get(Name name, int index) {
        Iterator it = this.attic.iterator();
        while (it.hasNext()) {
            NodeEntryImpl ne = (NodeEntryImpl)it.next();
            if (!ne.matches(name, index)) continue;
            return ne;
        }
        return null;
    }

    NodeEntry get(String uniqueId) {
        if (uniqueId == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = this.attic.iterator();
        while (it.hasNext()) {
            NodeEntryImpl ne = (NodeEntryImpl)it.next();
            if (!uniqueId.equals(ne.getUniqueID())) continue;
            return ne;
        }
        return null;
    }

    void add(NodeEntryImpl movedEntry) {
        this.attic.add(movedEntry);
    }

    boolean remove(NodeEntryImpl movedEntry) {
        if (this.attic.contains(movedEntry)) {
            return this.attic.remove(movedEntry);
        }
        return false;
    }

    Iterator iterator() {
        return this.attic.iterator();
    }

    void clear() {
        if (this.attic != null) {
            this.attic.clear();
        }
    }
}

