/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HierarchyEntryImpl
implements HierarchyEntry {
    private static Logger log = LoggerFactory.getLogger((Class)HierarchyEntryImpl.class);
    private Reference target;
    protected Name name;
    protected NodeEntryImpl parent;
    protected final EntryFactory factory;

    HierarchyEntryImpl(NodeEntryImpl parent, Name name, EntryFactory factory) {
        this.parent = parent;
        this.name = name;
        this.factory = factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemState resolve() throws ItemNotFoundException, RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            try {
                state = this.doResolve();
                if (this.internalGetItemState() != null) return state;
                this.setItemState(state);
                return state;
            }
            catch (ItemNotFoundException e) {
                this.remove();
                throw e;
            }
        } else {
            if (state.getStatus() != 0) return state;
            this.reload(false);
        }
        return state;
    }

    abstract ItemState doResolve() throws ItemNotFoundException, RepositoryException;

    abstract Path buildPath(boolean var1) throws RepositoryException;

    ItemState internalGetItemState() {
        ItemState state = null;
        if (this.target != null) {
            state = (ItemState)this.target.get();
        }
        return state;
    }

    public Name getName() {
        return this.name;
    }

    public Path getPath() throws RepositoryException {
        return this.buildPath(false);
    }

    public Path getWorkspacePath() throws RepositoryException {
        return this.buildPath(true);
    }

    public NodeEntry getParent() {
        return this.parent;
    }

    public int getStatus() {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return -1;
        }
        return state.getStatus();
    }

    public boolean isAvailable() {
        return this.internalGetItemState() != null;
    }

    public ItemState getItemState() throws ItemNotFoundException, RepositoryException {
        ItemState state = this.resolve();
        return state;
    }

    public synchronized void setItemState(ItemState state) {
        ItemState currentState = this.internalGetItemState();
        if (state == null || state == currentState || this.denotesNode() != state.isNode()) {
            throw new IllegalArgumentException();
        }
        if (currentState == null) {
            this.target = new SoftReference<ItemState>(state);
        } else {
            int currentStatus = currentState.getStatus();
            boolean keepChanges = Status.isTransient(currentStatus) || Status.isStale(currentStatus);
            ItemState.MergeResult mergeResult = currentState.merge(state, keepChanges);
            if (currentStatus == 0) {
                currentState.setStatus(1);
            } else if (mergeResult.modified()) {
                currentState.setStatus(7);
            }
            mergeResult.dispose();
        }
    }

    public void invalidate(boolean recursive) {
        if (this.getStatus() == 1) {
            ItemState state = this.internalGetItemState();
            state.setStatus(0);
        } else {
            log.debug("Skip invalidation for HierarchyEntry " + this.name + " with status " + Status.getName(this.getStatus()));
        }
    }

    public void revert() throws RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return;
        }
        int oldStatus = state.getStatus();
        switch (oldStatus) {
            case 2: 
            case 5: {
                state.revert();
                state.setStatus(1);
                break;
            }
            case 3: {
                state.revert();
                state.setStatus(1);
                break;
            }
            case 4: {
                state.setStatus(8);
                this.parent.internalRemoveChildEntry(this);
                break;
            }
            case 6: {
                this.remove();
                break;
            }
            default: {
                log.debug("State with status " + oldStatus + " cannot be reverted.");
            }
        }
    }

    public void reload(boolean recursive) {
        int status = this.getStatus();
        if (status == -1) {
            return;
        }
        if (Status.isTransient(status) || Status.isStale(status) || Status.isTerminal(status)) {
            log.debug("Skip reload for item with status " + Status.getName(status) + ".");
            return;
        }
        try {
            TransientItemStateFactory isf = this.factory.getItemStateFactory();
            if (this.denotesNode()) {
                NodeEntry ne = (NodeEntry)((Object)this);
                isf.createNodeState(ne.getWorkspaceId(), ne);
            } else {
                PropertyEntry pe = (PropertyEntry)((Object)this);
                isf.createPropertyState(pe.getWorkspaceId(), pe);
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("Item '" + this.getName() + "' cannot be found on the persistent layer -> remove.");
            this.remove();
        }
        catch (RepositoryException e) {
            log.error("Exception while reloading item: " + (Object)((Object)e));
        }
    }

    public void transientRemove() throws InvalidItemStateException, RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return;
        }
        if (state.getStatus() == 0) {
            this.reload(false);
        }
        switch (state.getStatus()) {
            case 4: {
                state.setStatus(8);
                this.parent.internalRemoveChildEntry(this);
                break;
            }
            case 1: 
            case 2: {
                state.setStatus(3);
                break;
            }
            case 6: 
            case 8: {
                throw new InvalidItemStateException("Item has already been removed by someone else. Status = " + Status.getName(state.getStatus()));
            }
            default: {
                throw new RepositoryException("Cannot transiently remove an ItemState with status " + Status.getName(state.getStatus()));
            }
        }
    }

    public void remove() {
        this.internalRemove(false);
    }

    void internalRemove(boolean staleParent) {
        ItemState state = this.internalGetItemState();
        int status = this.getStatus();
        if (state != null) {
            if (status == 2) {
                state.setStatus(6);
            } else if (status != 4 || !staleParent) {
                state.setStatus(8);
                if (!staleParent) {
                    this.parent.internalRemoveChildEntry(this);
                }
            }
        } else if (!staleParent) {
            this.parent.internalRemoveChildEntry(this);
        }
    }
}

