/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveNodeTypeImpl
implements Cloneable,
EffectiveNodeType {
    private static Logger log = LoggerFactory.getLogger((Class)EffectiveNodeTypeImpl.class);
    private final TreeSet mergedNodeTypes = new TreeSet();
    private final TreeSet inheritedNodeTypes = new TreeSet();
    private final TreeSet allNodeTypes = new TreeSet();
    private final Map namedItemDefs = new HashMap();
    private final List unnamedItemDefs = new ArrayList();
    private Set supportedMixins;

    EffectiveNodeTypeImpl(TreeSet mergedNodeTypes, TreeSet inheritedNodeTypes, TreeSet allNodeTypes, Map namedItemDefs, List unnamedItemDefs, Set supportedMixins) {
        this.mergedNodeTypes.addAll(mergedNodeTypes);
        this.inheritedNodeTypes.addAll(inheritedNodeTypes);
        this.allNodeTypes.addAll(allNodeTypes);
        Iterator iter = namedItemDefs.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            List list = (List)namedItemDefs.get(key);
            this.namedItemDefs.put(key, new ArrayList(list));
        }
        this.unnamedItemDefs.addAll(unnamedItemDefs);
        if (supportedMixins != null) {
            this.supportedMixins = new HashSet();
            this.supportedMixins.addAll(supportedMixins);
        }
    }

    public Name[] getInheritedNodeTypes() {
        return this.inheritedNodeTypes.toArray(new Name[this.inheritedNodeTypes.size()]);
    }

    public Name[] getAllNodeTypes() {
        return this.allNodeTypes.toArray(new Name[this.allNodeTypes.size()]);
    }

    public Name[] getMergedNodeTypes() {
        return this.mergedNodeTypes.toArray(new Name[this.mergedNodeTypes.size()]);
    }

    public QNodeDefinition[] getAllQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        Iterator<Object> iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (!qDef.definesNode()) continue;
            defs.add(qDef);
        }
        iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (!qDef.definesNode()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getAllQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        Iterator<Object> iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (qDef.definesNode()) continue;
            defs.add(qDef);
        }
        iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (qDef.definesNode()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QNodeDefinition[] getAutoCreateQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (!qDef.definesNode() || !qDef.isAutoCreated()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getAutoCreateQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (qDef.definesNode() || !qDef.isAutoCreated()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getMandatoryQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (qDef.definesNode() || !qDef.isMandatory()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QNodeDefinition[] getMandatoryQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                QItemDefinition qDef = (QItemDefinition)iter1.next();
                if (!qDef.definesNode() || !qDef.isMandatory()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getNamedQNodeDefinitions(Name name) {
        List list = (List)this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (!qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getUnnamedQNodeDefinitions() {
        if (this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.unnamedItemDefs.size());
        Iterator iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (!qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getNamedQPropertyDefinitions(Name name) {
        List list = (List)this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getUnnamedQPropertyDefinitions() {
        if (this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.unnamedItemDefs.size());
        Iterator iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            QItemDefinition qDef = (QItemDefinition)iter.next();
            if (qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public boolean includesNodeType(Name nodeTypeName) {
        return this.allNodeTypes.contains(nodeTypeName);
    }

    public boolean includesNodeTypes(Name[] nodeTypeNames) {
        return this.allNodeTypes.containsAll(Arrays.asList(nodeTypeNames));
    }

    public boolean supportsMixin(Name mixin) {
        if (this.supportedMixins == null) {
            return true;
        }
        return this.supportedMixins.contains(mixin);
    }

    public void checkAddNodeConstraints(Name name, ItemDefinitionProvider definitionProvider) throws ConstraintViolationException {
        try {
            definitionProvider.getQNodeDefinition(this, name, null);
        }
        catch (NoSuchNodeTypeException e) {
            String msg = "internal eror: inconsistent node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)e);
        }
    }

    public void checkAddNodeConstraints(Name name, Name nodeTypeName, ItemDefinitionProvider definitionProvider) throws ConstraintViolationException, NoSuchNodeTypeException {
        QNodeDefinition nd = definitionProvider.getQNodeDefinition(this, name, nodeTypeName);
        if (nd.isProtected()) {
            throw new ConstraintViolationException(name + " is protected");
        }
        if (nd.isAutoCreated()) {
            throw new ConstraintViolationException(name + " is auto-created and can not be manually added");
        }
    }

    public void checkRemoveItemConstraints(Name name) throws ConstraintViolationException {
        QItemDefinition[] defs = this.getNamedItemDefs(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory item");
                }
                if (!defs[i].isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected item");
            }
        }
    }

    private QItemDefinition[] getNamedItemDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        ArrayList defs = new ArrayList(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            defs.addAll((List)iter.next());
        }
        if (defs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QItemDefinition[defs.size()]);
    }

    private QItemDefinition[] getNamedItemDefs(Name name) {
        List list = (List)this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return list.toArray(new QItemDefinition[list.size()]);
    }

    private QItemDefinition[] getUnnamedItemDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return this.unnamedItemDefs.toArray(new QItemDefinition[this.unnamedItemDefs.size()]);
    }

    EffectiveNodeTypeImpl merge(EffectiveNodeTypeImpl other) throws ConstraintViolationException {
        EffectiveNodeTypeImpl copy = (EffectiveNodeTypeImpl)this.clone();
        copy.internalMerge(other, false);
        return copy;
    }

    synchronized void internalMerge(EffectiveNodeTypeImpl other, boolean supertype) throws ConstraintViolationException {
        String msg;
        QItemDefinition qDef;
        int i;
        Name[] nta = other.getAllNodeTypes();
        int includedCount = 0;
        for (int i2 = 0; i2 < nta.length; ++i2) {
            if (!this.includesNodeType(nta[i2])) continue;
            log.debug("node type '" + nta[i2] + "' is already contained.");
            ++includedCount;
        }
        if (includedCount == nta.length) {
            return;
        }
        QItemDefinition[] defs = other.getNamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            qDef = defs[i];
            if (this.includesNodeType(qDef.getDeclaringNodeType())) continue;
            Name name = qDef.getName();
            ArrayList<QItemDefinition> existingDefs = (ArrayList<QItemDefinition>)this.namedItemDefs.get(name);
            if (existingDefs != null) {
                if (existingDefs.size() > 0) {
                    for (int j = 0; j < existingDefs.size(); ++j) {
                        QItemDefinition qItemDef = (QItemDefinition)existingDefs.get(j);
                        if (qDef.isAutoCreated() || qItemDef.isAutoCreated()) {
                            msg = "The item definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': name collision with auto-create definition";
                            log.debug(msg);
                            throw new ConstraintViolationException(msg);
                        }
                        if (qDef.definesNode() != qItemDef.definesNode()) continue;
                        if (!qDef.definesNode()) {
                            QPropertyDefinition pd = (QPropertyDefinition)qDef;
                            QPropertyDefinition epd = (QPropertyDefinition)qItemDef;
                            if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                            String msg2 = "The property definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': ambiguous property definition. " + "they must differ in required type " + "or cardinality.";
                            log.debug(msg2);
                            throw new ConstraintViolationException(msg2);
                        }
                        msg = "The child node definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': ambiguous child node definition. name must differ.";
                        log.debug(msg);
                        throw new ConstraintViolationException(msg);
                    }
                }
            } else {
                existingDefs = new ArrayList<QItemDefinition>();
                this.namedItemDefs.put(name, existingDefs);
            }
            existingDefs.add(qDef);
        }
        defs = other.getUnnamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            qDef = defs[i];
            if (this.includesNodeType(qDef.getDeclaringNodeType())) continue;
            Iterator iter = this.unnamedItemDefs.iterator();
            while (iter.hasNext()) {
                QItemDefinition existing = (QItemDefinition)iter.next();
                if (qDef.definesNode() != existing.definesNode()) continue;
                if (!qDef.definesNode()) {
                    QPropertyDefinition pd = (QPropertyDefinition)qDef;
                    QPropertyDefinition epd = (QPropertyDefinition)existing;
                    if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple() || pd.getOnParentVersion() != epd.getOnParentVersion()) continue;
                    msg = "A property definition in node type '" + qDef.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual property definition";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                QNodeDefinition nd = (QNodeDefinition)qDef;
                QNodeDefinition end = (QNodeDefinition)existing;
                if (!Arrays.equals(nd.getRequiredPrimaryTypes(), end.getRequiredPrimaryTypes()) || !(nd.getDefaultPrimaryType() == null ? end.getDefaultPrimaryType() == null : nd.getDefaultPrimaryType().equals(end.getDefaultPrimaryType()))) continue;
                msg = "A child node definition in node type '" + qDef.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual child node definition";
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            this.unnamedItemDefs.add(qDef);
        }
        for (i = 0; i < nta.length; ++i) {
            this.allNodeTypes.add(nta[i]);
        }
        if (supertype) {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        } else {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.mergedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        }
    }

    protected Object clone() {
        EffectiveNodeTypeImpl clone = new EffectiveNodeTypeImpl(this.mergedNodeTypes, this.inheritedNodeTypes, this.allNodeTypes, this.namedItemDefs, this.unnamedItemDefs, this.supportedMixins);
        return clone;
    }
}

