/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ItemDefinitionImpl
implements ItemDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)ItemDefinitionImpl.class);
    protected static final String ANY_NAME = "*";
    protected final NodeTypeManagerImpl ntMgr;
    protected final NamePathResolver resolver;
    protected final QItemDefinition itemDef;

    ItemDefinitionImpl(QItemDefinition itemDef, NodeTypeManagerImpl ntMgr, NamePathResolver resolver) {
        this.itemDef = itemDef;
        this.ntMgr = ntMgr;
        this.resolver = resolver;
    }

    public NodeType getDeclaringNodeType() {
        try {
            return this.ntMgr.getNodeType(this.itemDef.getDeclaringNodeType());
        }
        catch (NoSuchNodeTypeException e) {
            log.error("declaring node type does not exist", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        if (this.itemDef.definesResidual()) {
            return ANY_NAME;
        }
        try {
            return this.resolver.getJCRName(this.itemDef.getName());
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in property name", (Throwable)e);
            return this.itemDef.getName().toString();
        }
    }

    public int getOnParentVersion() {
        return this.itemDef.getOnParentVersion();
    }

    public boolean isAutoCreated() {
        return this.itemDef.isAutoCreated();
    }

    public boolean isMandatory() {
        return this.itemDef.isMandatory();
    }

    public boolean isProtected() {
        return this.itemDef.isProtected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemDefinitionImpl)) {
            return false;
        }
        return this.itemDef.equals(((ItemDefinitionImpl)o).itemDef);
    }

    public int hashCode() {
        return this.itemDef.hashCode();
    }
}

