/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDefinitionImpl
extends ItemDefinitionImpl
implements NodeDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)NodeDefinitionImpl.class);

    NodeDefinitionImpl(QNodeDefinition nodeDef, NodeTypeManagerImpl ntMgr, NamePathResolver resolver) {
        super((QItemDefinition)nodeDef, ntMgr, resolver);
    }

    public NodeType getDefaultPrimaryType() {
        Name ntName = ((QNodeDefinition)this.itemDef).getDefaultPrimaryType();
        if (ntName == null) {
            return null;
        }
        try {
            return this.ntMgr.getNodeType(ntName);
        }
        catch (NoSuchNodeTypeException e) {
            log.error("invalid default node type " + ntName, (Throwable)e);
            return null;
        }
    }

    public NodeType[] getRequiredPrimaryTypes() {
        Name[] ntNames = ((QNodeDefinition)this.itemDef).getRequiredPrimaryTypes();
        try {
            if (ntNames == null || ntNames.length == 0) {
                return new NodeType[]{this.ntMgr.getNodeType(NameConstants.NT_BASE)};
            }
            NodeType[] nodeTypes = new NodeType[ntNames.length];
            for (int i = 0; i < ntNames.length; ++i) {
                nodeTypes[i] = this.ntMgr.getNodeType(ntNames[i]);
            }
            return nodeTypes;
        }
        catch (NoSuchNodeTypeException e) {
            log.error("required node type does not exist", (Throwable)e);
            return new NodeType[0];
        }
    }

    public boolean allowsSameNameSiblings() {
        return ((QNodeDefinition)this.itemDef).allowsSameNameSiblings();
    }
}

