/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.jcr2spi.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeManagerImpl
implements NodeTypeManager,
NodeTypeRegistryListener,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeManagerImpl.class);
    private final ManagerProvider mgrProvider;
    private final NodeTypeRegistry ntReg;
    private final ValueFactory valueFactory;
    private final Map ntCache;
    private final Map pdCache;
    private final Map ndCache;

    public NodeTypeManagerImpl(NodeTypeRegistry ntReg, ManagerProvider mgrProvider, ValueFactory valueFactory) {
        this.mgrProvider = mgrProvider;
        this.ntReg = ntReg;
        this.ntReg.addListener(this);
        this.valueFactory = valueFactory;
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
    }

    private NamespaceResolver nsResolver() {
        return this.mgrProvider.getNamespaceResolver();
    }

    private NamePathResolver resolver() {
        return this.mgrProvider.getNamePathResolver();
    }

    private EffectiveNodeTypeProvider entProvider() {
        return this.mgrProvider.getEffectiveNodeTypeProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeImpl getNodeType(Name name) throws NoSuchNodeTypeException {
        Map map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = (NodeTypeImpl)this.ntCache.get(name);
            if (nt == null) {
                EffectiveNodeType ent = this.entProvider().getEffectiveNodeType(name);
                QNodeTypeDefinition def = this.ntReg.getNodeTypeDefinition(name);
                nt = new NodeTypeImpl(ent, def, this, this.mgrProvider);
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    public boolean hasNodeType(Name nodeTypeName) {
        boolean isRegistered = this.ntCache.containsKey(nodeTypeName);
        if (!isRegistered) {
            isRegistered = this.ntReg.isRegistered(nodeTypeName);
        }
        return isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDefinition getNodeDefinition(QNodeDefinition def) {
        Map map = this.ndCache;
        synchronized (map) {
            NodeDefinition ndi = (NodeDefinition)this.ndCache.get(def);
            if (ndi == null) {
                ndi = new NodeDefinitionImpl(def, this, this.resolver());
                this.ndCache.put(def, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinition getPropertyDefinition(QPropertyDefinition def) {
        Map map = this.pdCache;
        synchronized (map) {
            PropertyDefinition pdi = (PropertyDefinition)this.pdCache.get(def);
            if (pdi == null) {
                pdi = new PropertyDefinitionImpl(def, this, this.resolver(), this.valueFactory);
                this.pdCache.put(def, pdi);
            }
            return pdi;
        }
    }

    NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    public void nodeTypeRegistered(Name ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeReRegistered(Name ntName) {
        this.ntCache.remove(ntName);
        try {
            Iterator iter;
            String name = this.resolver().getJCRName(ntName);
            Map map = this.pdCache;
            synchronized (map) {
                iter = this.pdCache.values().iterator();
                while (iter.hasNext()) {
                    PropertyDefinition pd = (PropertyDefinition)iter.next();
                    if (!name.equals(pd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
            map = this.ndCache;
            synchronized (map) {
                iter = this.ndCache.values().iterator();
                while (iter.hasNext()) {
                    NodeDefinition nd = (NodeDefinition)iter.next();
                    if (!name.equals(nd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
        }
        catch (NamespaceException e) {
            log.warn(e.getMessage() + " -> clear definition cache.");
            Map map = this.pdCache;
            synchronized (map) {
                this.pdCache.clear();
            }
            map = this.ndCache;
            synchronized (map) {
                this.ndCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(Name ntName) {
        this.ntCache.remove(ntName);
        try {
            Iterator iter;
            String name = this.resolver().getJCRName(ntName);
            Map map = this.pdCache;
            synchronized (map) {
                iter = this.pdCache.values().iterator();
                while (iter.hasNext()) {
                    PropertyDefinition pd = (PropertyDefinition)iter.next();
                    if (!name.equals(pd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
            map = this.ndCache;
            synchronized (map) {
                iter = this.ndCache.values().iterator();
                while (iter.hasNext()) {
                    NodeDefinition nd = (NodeDefinition)iter.next();
                    if (!name.equals(nd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
        }
        catch (NamespaceException e) {
            log.warn(e.getMessage() + " -> clear definition cache.");
            Map map = this.pdCache;
            synchronized (map) {
                this.pdCache.clear();
            }
            map = this.ndCache;
            synchronized (map) {
                this.ndCache.clear();
            }
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            list.add(this.getNodeType(ntNames[i]));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            Name qName = this.resolver().getQName(nodeTypeName);
            return this.getNodeType(qName);
        }
        catch (NamespaceException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
        catch (NameException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeManager (" + this + ")");
        ps.println();
        ps.println("All NodeTypes:");
        ps.println();
        try {
            NodeTypeIterator iter = this.getAllNodeTypes();
            while (iter.hasNext()) {
                NodeType nt = iter.nextNodeType();
                ps.println(nt.getName());
                NodeType[] supertypes = nt.getSupertypes();
                ps.println("\tSupertypes");
                for (int i = 0; i < supertypes.length; ++i) {
                    ps.println("\t\t" + supertypes[i].getName());
                }
                ps.println("\tMixin\t" + nt.isMixin());
                ps.println("\tOrderableChildNodes\t" + nt.hasOrderableChildNodes());
                ps.println("\tPrimaryItemName\t" + (nt.getPrimaryItemName() == null ? "<null>" : nt.getPrimaryItemName()));
                PropertyDefinition[] pd = nt.getPropertyDefinitions();
                for (int i = 0; i < pd.length; ++i) {
                    ps.print("\tPropertyDefinition");
                    ps.println(" (declared in " + pd[i].getDeclaringNodeType().getName() + ") ");
                    ps.println("\t\tName\t\t" + pd[i].getName());
                    String type = pd[i].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)pd[i].getRequiredType());
                    ps.println("\t\tRequiredType\t" + type);
                    String[] vca = pd[i].getValueConstraints();
                    StringBuffer constraints = new StringBuffer();
                    if (vca == null) {
                        constraints.append("<null>");
                    } else {
                        for (int n = 0; n < vca.length; ++n) {
                            if (constraints.length() > 0) {
                                constraints.append(", ");
                            }
                            constraints.append(vca[n]);
                        }
                    }
                    ps.println("\t\tValueConstraints\t" + constraints.toString());
                    Value[] defVals = pd[i].getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        for (int n = 0; n < defVals.length; ++n) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            defaultValues.append(defVals[n].getString());
                        }
                    }
                    ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                    ps.println("\t\tAutoCreated\t" + pd[i].isAutoCreated());
                    ps.println("\t\tMandatory\t" + pd[i].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)pd[i].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + pd[i].isProtected());
                    ps.println("\t\tMultiple\t" + pd[i].isMultiple());
                }
                NodeDefinition[] nd = nt.getChildNodeDefinitions();
                for (int i = 0; i < nd.length; ++i) {
                    NodeType defPrimaryType;
                    ps.print("\tNodeDefinition");
                    ps.println(" (declared in " + nd[i].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + nd[i].getName());
                    NodeType[] reqPrimaryTypes = nd[i].getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        for (int n = 0; n < reqPrimaryTypes.length; ++n) {
                            ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n].getName());
                        }
                    }
                    if ((defPrimaryType = nd[i].getDefaultPrimaryType()) != null) {
                        ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType.getName());
                    }
                    ps.println("\n\t\tAutoCreated\t" + nd[i].isAutoCreated());
                    ps.println("\t\tMandatory\t" + nd[i].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nd[i].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + nd[i].isProtected());
                    ps.println("\t\tAllowsSameNameSiblings\t" + nd[i].allowsSameNameSiblings());
                }
            }
            ps.println();
        }
        catch (RepositoryException e) {
            e.printStackTrace(ps);
        }
    }
}

