/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.DefinitionValidator;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidNodeTypeDefException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRegistryImpl
implements Dumpable,
NodeTypeRegistry,
EffectiveNodeTypeProvider {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeRegistryImpl.class);
    private final EffectiveNodeTypeCache entCache;
    private final NodeTypeDefinitionMap registeredNTDefs;
    private final Set propDefs;
    private final Set nodeDefs;
    private final NodeTypeStorage storage;
    private final DefinitionValidator validator;
    private final Map listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));

    public static NodeTypeRegistryImpl create(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        NodeTypeRegistryImpl ntRegistry = new NodeTypeRegistryImpl(storage, nsRegistry);
        return ntRegistry;
    }

    public synchronized void dispose() {
        this.entCache.clear();
        this.registeredNTDefs.clear();
        this.propDefs.clear();
        this.nodeDefs.clear();
        this.listeners.clear();
    }

    private NodeTypeRegistryImpl(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        this.storage = storage;
        this.validator = new DefinitionValidator(this, nsRegistry);
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new NodeTypeDefinitionMap();
        this.propDefs = new HashSet();
        this.nodeDefs = new HashSet();
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public Name[] getRegisteredNodeTypes() throws RepositoryException {
        Set qNames = this.registeredNTDefs.keySet();
        return qNames.toArray(new Name[this.registeredNTDefs.size()]);
    }

    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    public synchronized EffectiveNodeType registerNodeType(QNodeTypeDefinition ntDef) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.validator.validateNodeTypeDef(ntDef, this.registeredNTDefs);
        this.storage.registerNodeTypes(new QNodeTypeDefinition[]{ntDef});
        this.internalRegister(ntDef, ent);
        this.notifyRegistered(ntDef.getName());
        return ent;
    }

    public synchronized void registerNodeTypes(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        Map defMap = this.validator.validateNodeTypeDefs(ntDefs, this.registeredNTDefs);
        this.storage.registerNodeTypes(ntDefs.toArray(new QNodeTypeDefinition[ntDefs.size()]));
        this.internalRegister(defMap);
        Iterator iter = ntDefs.iterator();
        while (iter.hasNext()) {
            Name ntName = ((QNodeTypeDefinition)iter.next()).getName();
            this.notifyRegistered(ntName);
        }
    }

    public void unregisterNodeType(Name nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        ntNames.add(nodeTypeName);
        this.unregisterNodeTypes(ntNames);
    }

    public synchronized void unregisterNodeTypes(Collection nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        Name ntName;
        Iterator iter = nodeTypeNames.iterator();
        while (iter.hasNext()) {
            ntName = (Name)iter.next();
            Set dependents = this.registeredNTDefs.getDependentNodeTypes(ntName);
            dependents.removeAll(nodeTypeNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            Iterator depIter = dependents.iterator();
            while (depIter.hasNext()) {
                msg.append(depIter.next());
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        this.storage.unregisterNodeTypes(nodeTypeNames.toArray(new Name[nodeTypeNames.size()]));
        this.internalUnregister(nodeTypeNames);
        iter = nodeTypeNames.iterator();
        while (iter.hasNext()) {
            ntName = (Name)iter.next();
            this.notifyUnregistered(ntName);
        }
    }

    public synchronized EffectiveNodeType reregisterNodeType(QNodeTypeDefinition ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (!this.registeredNTDefs.containsKey(name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        EffectiveNodeType ent = this.validator.validateNodeTypeDef(ntd, this.registeredNTDefs);
        this.storage.reregisterNodeTypes(new QNodeTypeDefinition[]{ntd});
        this.internalUnregister(name);
        this.internalRegister(ntd, ent);
        this.notifyReRegistered(name);
        return ent;
    }

    public QNodeTypeDefinition getNodeTypeDefinition(Name nodeTypeName) throws NoSuchNodeTypeException {
        QNodeTypeDefinition def = (QNodeTypeDefinition)this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException("Nodetype " + nodeTypeName + " doesn't exist");
        }
        return def;
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntName, this.entCache, (Map)this.registeredNTDefs);
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(Name[] ntNames) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, (Map)this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Name[] ntNames, Map ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, ntdMap);
    }

    public EffectiveNodeType getEffectiveNodeType(QNodeTypeDefinition ntd, Map ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        TreeSet<Name> mergedNodeTypes = new TreeSet<Name>();
        TreeSet inheritedNodeTypes = new TreeSet();
        TreeSet<Name> allNodeTypes = new TreeSet<Name>();
        HashMap namedItemDefs = new HashMap();
        ArrayList<Object> unnamedItemDefs = new ArrayList<Object>();
        HashSet<Name> supportedMixins = null;
        Name ntName = ntd.getName();
        mergedNodeTypes.add(ntName);
        allNodeTypes.add(ntName);
        Name[] smixins = ntd.getSupportedMixinTypes();
        if (smixins != null) {
            supportedMixins = new HashSet<Name>();
            for (int i = 0; i < smixins.length; ++i) {
                supportedMixins.add(smixins[i]);
            }
        }
        HashSet<Object> itemDefIds = new HashSet<Object>();
        QNodeDefinition[] cnda = ntd.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            if (itemDefIds.contains(cnda[i])) {
                String msg = cnda[i].definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + cnda[i].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(cnda[i]);
            if (cnda[i].definesResidual()) {
                unnamedItemDefs.add(cnda[i]);
                continue;
            }
            Name name = cnda[i].getName();
            ArrayList<QNodeDefinition> defs = (ArrayList<QNodeDefinition>)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QNodeDefinition>();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    QItemDefinition qDef = (QItemDefinition)defs.get(j);
                    if (!cnda[i].isAutoCreated() && !qDef.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            defs.add(cnda[i]);
        }
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            if (itemDefIds.contains(pda[i])) {
                String msg = pda[i].definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + pda[i].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(pda[i]);
            if (pda[i].definesResidual()) {
                unnamedItemDefs.add(pda[i]);
                continue;
            }
            Name name = pda[i].getName();
            ArrayList<QPropertyDefinition> defs = (ArrayList<QPropertyDefinition>)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QPropertyDefinition>();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    QItemDefinition qDef = (QItemDefinition)defs.get(j);
                    if (!pda[i].isAutoCreated() && !qDef.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            defs.add(pda[i]);
        }
        EffectiveNodeTypeImpl ent = new EffectiveNodeTypeImpl(mergedNodeTypes, inheritedNodeTypes, allNodeTypes, namedItemDefs, unnamedItemDefs, supportedMixins);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeTypeImpl effSuperType = (EffectiveNodeTypeImpl)this.getEffectiveNodeType(supertypes, ntdMap);
            ent.internalMerge(effSuperType, true);
        }
        return ent;
    }

    private EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        QNodeTypeDefinition ntd = (QNodeTypeDefinition)ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = this.getEffectiveNodeType(ntd, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (ConstraintViolationException e) {
                String msg = "Internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map ntdCache) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (int i = 0; i < ntNames.length; ++i) {
            if (ntdCache.containsKey(ntNames[i])) continue;
            throw new NoSuchNodeTypeException(ntNames[i].toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeTypeImpl result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeTypeImpl ent = (EffectiveNodeTypeImpl)entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                Name[] remainder = key.getNames();
                for (int i = 0; i < remainder.length; ++i) {
                    QNodeTypeDefinition ntd = (QNodeTypeDefinition)ntdCache.get(remainder[i]);
                    EffectiveNodeType ent = this.getEffectiveNodeType(ntd, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = (EffectiveNodeTypeImpl)ent;
                        continue;
                    }
                    result = result.merge((EffectiveNodeTypeImpl)ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeUnregistered(ntName);
        }
    }

    private void internalRegister(Map defMap) {
        Iterator it = defMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            QNodeTypeDefinition ntd = (QNodeTypeDefinition)entry.getKey();
            this.internalRegister(ntd, (EffectiveNodeTypeImpl)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegister(QNodeTypeDefinition ntd, EffectiveNodeType ent) {
        if (ent != null) {
            this.entCache.put(ent);
        } else {
            log.debug("Effective node type for " + ntd + " not yet built.");
        }
        this.registeredNTDefs.put(ntd.getName(), ntd);
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        Set set = this.propDefs;
        synchronized (set) {
            for (int i = 0; i < pda.length; ++i) {
                this.propDefs.add(pda[i]);
            }
        }
        QNodeDefinition[] nda = ntd.getChildNodeDefs();
        Set set2 = this.nodeDefs;
        synchronized (set2) {
            for (int i = 0; i < nda.length; ++i) {
                this.nodeDefs.add(nda[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregister(Name name) {
        QNodeTypeDefinition ntd = (QNodeTypeDefinition)this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
        if (ntd != null) {
            QPropertyDefinition[] pda = ntd.getPropertyDefs();
            Set set = this.propDefs;
            synchronized (set) {
                for (int i = 0; i < pda.length; ++i) {
                    this.propDefs.remove(pda[i]);
                }
            }
            set = this.nodeDefs;
            synchronized (set) {
                QNodeDefinition[] nda = ntd.getChildNodeDefs();
                for (int i = 0; i < nda.length; ++i) {
                    this.nodeDefs.remove(nda[i]);
                }
            }
        }
    }

    private void internalUnregister(Collection ntNames) {
        Iterator iter = ntNames.iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            this.internalUnregister(name);
        }
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Known NodeTypes:");
        ps.println();
        this.registeredNTDefs.dump(ps);
        ps.println();
        this.entCache.dump(ps);
    }

    private class NodeTypeDefinitionMap
    implements Map,
    Dumpable {
        private final ConcurrentReaderHashMap nodetypeDefinitions = new ConcurrentReaderHashMap();

        private NodeTypeDefinitionMap() {
        }

        private Set getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
            if (!this.nodetypeDefinitions.containsKey((Object)nodeTypeName)) {
                throw new NoSuchNodeTypeException(nodeTypeName.toString());
            }
            HashSet<Name> names = new HashSet<Name>();
            Iterator iter = this.nodetypeDefinitions.values().iterator();
            while (iter.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iter.next();
                if (!ntd.getDependencies().contains(nodeTypeName)) continue;
                names.add(ntd.getName());
            }
            return names;
        }

        private void updateInternalMap(Iterator definitions) {
            while (definitions.hasNext()) {
                NodeTypeRegistryImpl.this.internalRegister((QNodeTypeDefinition)definitions.next(), null);
            }
        }

        public int size() {
            return this.nodetypeDefinitions.size();
        }

        public void clear() {
            this.nodetypeDefinitions.clear();
        }

        public boolean isEmpty() {
            return this.nodetypeDefinitions.isEmpty();
        }

        public boolean containsKey(Object key) {
            if (!(key instanceof Name)) {
                return false;
            }
            return this.get(key) != null;
        }

        public boolean containsValue(Object value) {
            if (!(value instanceof QNodeTypeDefinition)) {
                return false;
            }
            return this.get(((QNodeTypeDefinition)value).getName()) != null;
        }

        public Set keySet() {
            try {
                Iterator it = NodeTypeRegistryImpl.this.storage.getAllDefinitions();
                this.updateInternalMap(it);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            return this.nodetypeDefinitions.keySet();
        }

        public Collection values() {
            this.keySet();
            return this.nodetypeDefinitions.values();
        }

        public Object put(Object key, Object value) {
            return this.nodetypeDefinitions.put(key, value);
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException("Implementation missing");
        }

        public Set entrySet() {
            this.keySet();
            return this.nodetypeDefinitions.entrySet();
        }

        public Object get(Object key) {
            if (!(key instanceof Name)) {
                throw new IllegalArgumentException();
            }
            QNodeTypeDefinition def = (QNodeTypeDefinition)this.nodetypeDefinitions.get(key);
            if (def == null) {
                try {
                    Iterator it = NodeTypeRegistryImpl.this.storage.getDefinitions(new Name[]{(Name)key});
                    this.updateInternalMap(it);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            def = (QNodeTypeDefinition)this.nodetypeDefinitions.get(key);
            return def;
        }

        public Object remove(Object key) {
            return (QNodeTypeDefinition)this.nodetypeDefinitions.remove(key);
        }

        public void dump(PrintStream ps) {
            Iterator iter = this.nodetypeDefinitions.values().iterator();
            while (iter.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iter.next();
                ps.println(ntd.getName());
                Name[] supertypes = ntd.getSupertypes();
                ps.println("\tSupertypes");
                for (int i = 0; i < supertypes.length; ++i) {
                    ps.println("\t\t" + supertypes[i]);
                }
                ps.println("\tMixin\t" + ntd.isMixin());
                ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
                ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
                QPropertyDefinition[] pd = ntd.getPropertyDefs();
                for (int i = 0; i < pd.length; ++i) {
                    ps.print("\tPropertyDefinition");
                    ps.println(" (declared in " + pd[i].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (pd[i].definesResidual() ? "*" : pd[i].getName().toString()));
                    String type = pd[i].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)pd[i].getRequiredType());
                    ps.println("\t\tRequiredType\t" + type);
                    String[] vca = pd[i].getValueConstraints();
                    StringBuffer constraints = new StringBuffer();
                    if (vca == null) {
                        constraints.append("<null>");
                    } else {
                        for (int n = 0; n < vca.length; ++n) {
                            if (constraints.length() > 0) {
                                constraints.append(", ");
                            }
                            constraints.append(vca[n]);
                        }
                    }
                    ps.println("\t\tValueConstraints\t" + constraints.toString());
                    QValue[] defVals = pd[i].getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        for (int n = 0; n < defVals.length; ++n) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            try {
                                defaultValues.append(defVals[n].getString());
                                continue;
                            }
                            catch (RepositoryException e) {
                                defaultValues.append(defVals[n].toString());
                            }
                        }
                    }
                    ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                    ps.println("\t\tAutoCreated\t" + pd[i].isAutoCreated());
                    ps.println("\t\tMandatory\t" + pd[i].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)pd[i].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + pd[i].isProtected());
                    ps.println("\t\tMultiple\t" + pd[i].isMultiple());
                }
                QNodeDefinition[] nd = ntd.getChildNodeDefs();
                for (int i = 0; i < nd.length; ++i) {
                    Name defPrimaryType;
                    ps.print("\tNodeDefinition");
                    ps.println(" (declared in " + nd[i].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (nd[i].definesResidual() ? "*" : nd[i].getName().toString()));
                    Name[] reqPrimaryTypes = nd[i].getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        for (int n = 0; n < reqPrimaryTypes.length; ++n) {
                            ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n]);
                        }
                    }
                    if ((defPrimaryType = nd[i].getDefaultPrimaryType()) != null) {
                        ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                    }
                    ps.println("\n\t\tAutoCreated\t" + nd[i].isAutoCreated());
                    ps.println("\t\tMandatory\t" + nd[i].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nd[i].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + nd[i].isProtected());
                    ps.println("\t\tAllowsSameNameSiblings\t" + nd[i].allowsSameNameSiblings());
                }
            }
        }
    }
}

