/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventImpl
implements Event {
    private static final Logger log = LoggerFactory.getLogger((Class)EventImpl.class);
    private final NamePathResolver resolver;
    private final org.apache.jackrabbit.spi.Event event;
    private String stringValue;

    EventImpl(NamePathResolver resolver, org.apache.jackrabbit.spi.Event event) {
        this.resolver = resolver;
        this.event = event;
    }

    public int getType() {
        return this.event.getType();
    }

    public String getPath() throws RepositoryException {
        return this.resolver.getJCRPath(this.event.getPath());
    }

    public String getUserID() {
        return this.event.getUserID();
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Event: Path: ");
            try {
                sb.append(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Exception retrieving path: " + (Object)((Object)e));
                sb.append("[Error retrieving path]");
            }
            sb.append(", ").append(EventImpl.valueOf(this.getType())).append(": ");
            sb.append(", UserId: ").append(this.getUserID());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    private static String valueOf(int eventType) {
        if (eventType == 1) {
            return "NodeAdded";
        }
        if (eventType == 2) {
            return "NodeRemoved";
        }
        if (eventType == 4) {
            return "PropertyAdded";
        }
        if (eventType == 16) {
            return "PropertyChanged";
        }
        if (eventType == 8) {
            return "PropertyRemoved";
        }
        return "UnknownEventType";
    }
}

