/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.commons.iterator.EventListenerIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.observation.FilteredEventIterator;
import org.apache.jackrabbit.jcr2spi.observation.InternalEventListener;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationManagerImpl
implements ObservationManager,
InternalEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)ObservationManagerImpl.class);
    private final WorkspaceManager wspManager;
    private final NamePathResolver resolver;
    private final NodeTypeRegistry ntRegistry;
    private final Map subscriptions = new HashMap();
    private Map readOnlySubscriptions;

    public ObservationManagerImpl(WorkspaceManager wspManager, NamePathResolver resolver, NodeTypeRegistry ntRegistry) {
        this.wspManager = wspManager;
        this.resolver = resolver;
        this.ntRegistry = ntRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws RepositoryException {
        Name[] qNodeTypeNames;
        Path path;
        try {
            path = this.resolver.getQPath(absPath).getCanonicalPath();
        }
        catch (NameException e) {
            throw new RepositoryException("Malformed path: " + absPath);
        }
        if (nodeTypeNames == null) {
            qNodeTypeNames = null;
        } else {
            try {
                qNodeTypeNames = new Name[nodeTypeNames.length];
                for (int i = 0; i < nodeTypeNames.length; ++i) {
                    Name ntName = this.resolver.getQName(nodeTypeNames[i]);
                    if (!this.ntRegistry.isRegistered(ntName)) {
                        throw new RepositoryException("unknown node type: " + nodeTypeNames[i]);
                    }
                    qNodeTypeNames[i] = ntName;
                }
            }
            catch (NameException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        EventFilter filter = this.wspManager.createEventFilter(eventTypes, path, isDeep, uuids, qNodeTypeNames, noLocal);
        Map map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.put(listener, filter);
            this.readOnlySubscriptions = null;
        }
        if (this.subscriptions.size() == 1) {
            this.wspManager.addEventListener(this);
        } else {
            this.wspManager.updateEventFilters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) throws RepositoryException {
        Map map = this.subscriptions;
        synchronized (map) {
            if (this.subscriptions.remove(listener) != null) {
                this.readOnlySubscriptions = null;
            }
        }
        if (this.subscriptions.size() == 0) {
            this.wspManager.removeEventListener(this);
        } else {
            this.wspManager.updateEventFilters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        Map activeListeners;
        Map map = this.subscriptions;
        synchronized (map) {
            this.ensureReadOnlyMap();
            activeListeners = this.readOnlySubscriptions;
        }
        return new EventListenerIteratorAdapter(activeListeners.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getEventFilters() {
        ArrayList filters = new ArrayList();
        Map map = this.subscriptions;
        synchronized (map) {
            this.ensureReadOnlyMap();
            filters.addAll(this.readOnlySubscriptions.values());
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventBundle eventBundle) {
        Map activeListeners;
        Map map = this.subscriptions;
        synchronized (map) {
            this.ensureReadOnlyMap();
            activeListeners = this.readOnlySubscriptions;
        }
        Iterator it = activeListeners.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            EventListener listener = (EventListener)entry.getKey();
            EventFilter filter = (EventFilter)entry.getValue();
            FilteredEventIterator eventIter = new FilteredEventIterator(eventBundle, filter, this.resolver);
            if (!eventIter.hasNext()) continue;
            try {
                listener.onEvent((EventIterator)eventIter);
            }
            catch (Throwable t) {
                log.warn("EventConsumer threw exception: " + t.toString());
                log.debug("Stacktrace: ", t);
            }
        }
    }

    private void ensureReadOnlyMap() {
        if (this.readOnlySubscriptions == null) {
            this.readOnlySubscriptions = new HashMap(this.subscriptions);
        }
    }
}

