/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLabel
extends AbstractOperation {
    private static Logger log;
    private final NodeState versionHistoryState;
    private final NodeState versionState;
    private final Name label;
    private final boolean moveLabel;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AddLabel(NodeState versionHistoryState, NodeState versionState, Name label, boolean moveLabel) {
        this.versionHistoryState = versionHistoryState;
        this.versionState = versionState;
        this.label = label;
        this.moveLabel = moveLabel;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        try {
            NodeEntry vhEntry = (NodeEntry)this.versionHistoryState.getHierarchyEntry();
            NodeEntry lnEntry = vhEntry.getNodeEntry(NameConstants.JCR_VERSIONLABELS, 1);
            if (lnEntry != null) {
                lnEntry.invalidate(this.moveLabel);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
    }

    public NodeId getVersionHistoryId() throws RepositoryException {
        return this.versionHistoryState.getNodeEntry().getWorkspaceId();
    }

    public NodeId getVersionId() throws RepositoryException {
        return this.versionState.getNodeEntry().getWorkspaceId();
    }

    public Name getLabel() {
        return this.label;
    }

    public boolean moveLabel() {
        return this.moveLabel;
    }

    public static Operation create(NodeState versionHistoryState, NodeState versionState, Name label, boolean moveLabel) {
        return new AddLabel(versionHistoryState, versionState, label, moveLabel);
    }

    static {
        $assertionsDisabled = !AddLabel.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)AddLabel.class);
    }
}

