/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;

public class AddProperty
extends AbstractOperation {
    private final NodeId parentId;
    private final NodeState parentState;
    private final Name propertyName;
    private final int propertyType;
    private final QValue[] values;
    private final QPropertyDefinition definition;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AddProperty(NodeState parentState, Name propName, int propertyType, QValue[] values, QPropertyDefinition definition) throws RepositoryException {
        this.parentId = parentState.getNodeId();
        this.parentState = parentState;
        this.propertyName = propName;
        this.propertyType = propertyType;
        this.values = values;
        this.definition = definition;
        this.addAffectedItemState(parentState);
    }

    public void accept(OperationVisitor visitor) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        this.parentState.getHierarchyEntry().complete(this);
    }

    public void undo() throws RepositoryException {
        this.status = 2;
        this.parentState.getHierarchyEntry().complete(this);
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public NodeState getParentState() {
        return this.parentState;
    }

    public Name getPropertyName() {
        return this.propertyName;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public QValue[] getValues() {
        return this.values;
    }

    public boolean isMultiValued() {
        return this.definition.isMultiple();
    }

    public QPropertyDefinition getDefinition() {
        return this.definition;
    }

    public static Operation create(NodeState parentState, Name propName, int propertyType, QPropertyDefinition def, QValue[] values) throws RepositoryException {
        AddProperty ap = new AddProperty(parentState, propName, propertyType, values, def);
        return ap;
    }

    static {
        $assertionsDisabled = !AddProperty.class.desiredAssertionStatus();
    }
}

