/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkout
extends AbstractOperation {
    private static Logger log;
    private final NodeState nodeState;
    private final VersionManager mgr;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Checkout(NodeState nodeState, VersionManager mgr) {
        this.nodeState = nodeState;
        this.mgr = mgr;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        try {
            NodeEntry vhe = this.mgr.getVersionHistoryEntry(this.nodeState);
            if (vhe != null) {
                vhe.invalidate(true);
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to access Version history entry -> skip invalidation.", (Throwable)e);
        }
        NodeEntry nodeEntry = (NodeEntry)this.nodeState.getHierarchyEntry();
        Iterator entries = nodeEntry.getPropertyEntries();
        while (entries.hasNext()) {
            PropertyEntry pe = (PropertyEntry)entries.next();
            pe.invalidate(false);
        }
        nodeEntry.invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public static Operation create(NodeState nodeState, VersionManager mgr) {
        return new Checkout(nodeState, mgr);
    }

    static {
        $assertionsDisabled = !Checkout.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)Checkout.class);
    }
}

