/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.NodeId;

public class LockOperation
extends AbstractOperation {
    private final NodeState nodeState;
    private final boolean isDeep;
    private final boolean isSessionScoped;
    private final long timeoutHint;
    private final String ownerHint;
    private LockInfo lockInfo = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LockOperation(NodeState nodeState, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerHint) {
        this.nodeState = nodeState;
        this.isDeep = isDeep;
        this.isSessionScoped = isSessionScoped;
        this.timeoutHint = timeoutHint;
        this.ownerHint = ownerHint;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        this.nodeState.getHierarchyEntry().invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeId();
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public boolean isSessionScoped() {
        return this.isSessionScoped;
    }

    public long getTimeoutHint() {
        return this.timeoutHint;
    }

    public String getOwnerHint() {
        return this.ownerHint;
    }

    public void setLockInfo(LockInfo lockInfo) {
        if (lockInfo == null) {
            throw new IllegalArgumentException("IdIterator must not be null.");
        }
        if (this.lockInfo != null) {
            throw new IllegalStateException("Merge operation has already been executed -> FailedIds already set.");
        }
        this.lockInfo = lockInfo;
    }

    public LockInfo getLockInfo() {
        if (this.lockInfo == null) {
            throw new IllegalStateException("Merge operation has not been executed yet.");
        }
        return this.lockInfo;
    }

    public static LockOperation create(NodeState nodeState, boolean isDeep, boolean isSessionScoped) {
        return LockOperation.create(nodeState, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public static LockOperation create(NodeState nodeState, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerHint) {
        LockOperation lck = new LockOperation(nodeState, isDeep, isSessionScoped, timeoutHint, ownerHint);
        return lck;
    }

    static {
        $assertionsDisabled = !LockOperation.class.desiredAssertionStatus();
    }
}

