/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merge
extends AbstractOperation {
    private static Logger log;
    private final NodeState nodeState;
    private final String srcWorkspaceName;
    private final boolean bestEffort;
    private final VersionManager mgr;
    private Iterator failedIds = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Merge(NodeState nodeState, String srcWorkspaceName, boolean bestEffort, VersionManager mgr) {
        this.nodeState = nodeState;
        this.srcWorkspaceName = srcWorkspaceName;
        this.bestEffort = bestEffort;
        this.mgr = mgr;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        try {
            NodeEntry vhe = this.mgr.getVersionHistoryEntry(this.nodeState);
            if (vhe != null) {
                vhe.invalidate(true);
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while retrieving VersionHistory entry:", (Object)e.getMessage());
        }
        this.nodeState.getHierarchyEntry().invalidate(true);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public String getSourceWorkspaceName() {
        return this.srcWorkspaceName;
    }

    public boolean bestEffort() {
        return this.bestEffort;
    }

    public void setFailedIds(Iterator failedIds) {
        if (failedIds == null) {
            throw new IllegalArgumentException("IdIterator must not be null.");
        }
        if (this.failedIds != null) {
            throw new IllegalStateException("Merge operation has already been executed -> FailedIds already set.");
        }
        this.failedIds = failedIds;
    }

    public Iterator getFailedIds() {
        if (this.failedIds == null) {
            throw new IllegalStateException("Merge operation has not been executed yet.");
        }
        return this.failedIds;
    }

    public static Merge create(NodeState nodeState, String srcWorkspaceName, boolean bestEffort, VersionManager mgr) {
        return new Merge(nodeState, srcWorkspaceName, bestEffort, mgr);
    }

    static {
        $assertionsDisabled = !Merge.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)Merge.class);
    }
}

