/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;

public class ReorderNodes
extends AbstractOperation {
    private final NodeId parentId;
    private final NodeId insertId;
    private final NodeId beforeId;
    private final NodeState parentState;
    private final NodeState insert;
    private final NodeState before;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ReorderNodes(NodeState parentState, NodeState insert, NodeState before) throws RepositoryException {
        this.parentState = parentState;
        this.insert = insert;
        this.before = before;
        this.parentId = parentState.getNodeId();
        this.insertId = insert.getNodeId();
        this.beforeId = before == null ? null : before.getNodeId();
        this.addAffectedItemState(parentState);
    }

    public void accept(OperationVisitor visitor) throws ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        this.insert.getHierarchyEntry().complete(this);
    }

    public void undo() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 2;
        this.insert.getHierarchyEntry().complete(this);
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public NodeId getInsertId() {
        return this.insertId;
    }

    public NodeId getBeforeId() {
        return this.beforeId;
    }

    public NodeState getParentState() {
        return this.parentState;
    }

    public NodeState getInsertNode() {
        return this.insert;
    }

    public NodeState getBeforeNode() {
        return this.before;
    }

    public static Operation create(NodeState parentState, Path.Element srcName, Path.Element beforeName) throws ItemNotFoundException, RepositoryException {
        ReorderNodes.assertChildNodeEntries(parentState);
        NodeState insert = parentState.getChildNodeState(srcName.getName(), srcName.getNormalizedIndex());
        NodeState before = beforeName == null ? null : parentState.getChildNodeState(beforeName.getName(), beforeName.getNormalizedIndex());
        return new ReorderNodes(parentState, insert, before);
    }

    static {
        $assertionsDisabled = !ReorderNodes.class.desiredAssertionStatus();
    }
}

