/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class SetMixin
extends AbstractOperation {
    private final NodeId nodeId;
    private final NodeState nodeState;
    private final Name[] mixinNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SetMixin(NodeState nodeState, Name[] mixinNames) throws RepositoryException {
        this.nodeState = nodeState;
        this.nodeId = nodeState.getNodeId();
        this.mixinNames = mixinNames;
        this.addAffectedItemState(nodeState);
        try {
            if (nodeState.hasPropertyName(NameConstants.JCR_MIXINTYPES)) {
                this.addAffectedItemState(nodeState.getPropertyState(NameConstants.JCR_MIXINTYPES));
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void accept(OperationVisitor visitor) throws AccessDeniedException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        this.nodeState.getHierarchyEntry().complete(this);
    }

    public void undo() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 2;
        this.nodeState.getHierarchyEntry().complete(this);
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Name[] getMixinNames() {
        return this.mixinNames;
    }

    public static Operation create(NodeState nodeState, Name[] mixinNames) throws RepositoryException {
        if (nodeState == null || mixinNames == null) {
            throw new IllegalArgumentException();
        }
        SetMixin sm = new SetMixin(nodeState, mixinNames);
        return sm;
    }

    static {
        $assertionsDisabled = !SetMixin.class.desiredAssertionStatus();
    }
}

