/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.query.QueryResultImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class QueryImpl
implements Query {
    private final Session session;
    private final ManagerProvider mgrProvider;
    private final ItemManager itemManager;
    private String statement;
    private String language;
    private Node node;
    private WorkspaceManager wspManager;

    public QueryImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        this.session = session;
        this.mgrProvider = mgrProvider;
        this.itemManager = itemMgr;
        this.statement = statement;
        this.language = language;
        this.wspManager = wspManager;
        this.wspManager.checkQueryStatement(statement, language, this.getNamespaceMappings());
    }

    public QueryImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager, Node node) throws InvalidQueryException, RepositoryException {
        this.session = session;
        this.mgrProvider = mgrProvider;
        this.itemManager = itemMgr;
        this.node = node;
        this.wspManager = wspManager;
        NamePathResolver resolver = mgrProvider.getNamePathResolver();
        if (!node.isNodeType(resolver.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("Node is not of type nt:query");
        }
        if (node.getSession() != session) {
            throw new InvalidQueryException("Node belongs to a different session.");
        }
        this.statement = node.getProperty(resolver.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        this.language = node.getProperty(resolver.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        this.wspManager.checkQueryStatement(this.statement, this.language, this.getNamespaceMappings());
    }

    public QueryResult execute() throws RepositoryException {
        QueryInfo qI = this.wspManager.executeQuery(this.statement, this.language, this.getNamespaceMappings());
        return new QueryResultImpl(this.itemManager, this.mgrProvider, qI);
    }

    private Map getNamespaceMappings() throws RepositoryException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            mappings.put(prefixes[i], this.session.getNamespaceURI(prefixes[i]));
        }
        return mappings;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        if (this.node == null) {
            throw new ItemNotFoundException("Not a persistent query.");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        NamePathResolver resolver = this.mgrProvider.getNamePathResolver();
        try {
            Path p = resolver.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String jcrParent = resolver.getJCRPath(p.getAncestor(1));
            if (!this.session.itemExists(jcrParent)) {
                throw new PathNotFoundException(jcrParent);
            }
            String relPath = resolver.getJCRPath(p).substring(1);
            String ntName = resolver.getJCRName(NameConstants.NT_QUERY);
            Node queryNode = this.session.getRootNode().addNode(relPath, ntName);
            queryNode.setProperty(resolver.getJCRName(NameConstants.JCR_LANGUAGE), this.language);
            queryNode.setProperty(resolver.getJCRName(NameConstants.JCR_STATEMENT), this.statement);
            this.node = queryNode;
            return this.node;
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }
}

